/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.line;

import com.djrapitops.plan.delivery.rendering.json.graphs.line.LineGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.line.Point;
import com.djrapitops.plan.gathering.domain.Ping;
import java.util.ArrayList;
import java.util.List;

public class PingGraph {
    private final LineGraph maxGraph;
    private final LineGraph minGraph;
    private final LineGraph avgGraph;

    PingGraph(List<Ping> pings, boolean displayGaps) {
        ArrayList<Point> max = new ArrayList<Point>();
        ArrayList<Point> min = new ArrayList<Point>();
        ArrayList<Point> avg = new ArrayList<Point>();
        for (Ping ping : pings) {
            long date = ping.getDate();
            max.add(new Point((double)date, ping.getMax()));
            min.add(new Point((double)date, ping.getMin()));
            avg.add(new Point((double)date, ping.getAverage()));
        }
        this.maxGraph = new LineGraph(max, displayGaps);
        this.minGraph = new LineGraph(min, displayGaps);
        this.avgGraph = new LineGraph(avg, displayGaps);
    }

    public LineGraph getMaxGraph() {
        return this.maxGraph;
    }

    public LineGraph getMinGraph() {
        return this.minGraph;
    }

    public LineGraph getAvgGraph() {
        return this.avgGraph;
    }
}

