/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.pie;

import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.ActivityPie;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.Pie;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.ServerPreferencePie;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.WorldPie;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.WorldAliasSettings;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import java.util.Map;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PieGraphFactory {
    private final PlanConfig config;
    private final Locale locale;
    private final Theme theme;

    @Inject
    public PieGraphFactory(PlanConfig config, Locale locale, Theme theme) {
        this.config = config;
        this.locale = locale;
        this.theme = theme;
    }

    public Pie activityPie(Map<String, Integer> activityData) {
        String[] colors = this.theme.getPieColors(ThemeVal.GRAPH_ACTIVITY_PIE);
        return new ActivityPie(activityData, colors, ActivityIndex.getGroups(this.locale));
    }

    public Pie serverPreferencePie(Map<UUID, String> serverNames, Map<UUID, WorldTimes> serverWorldTimes) {
        return new ServerPreferencePie(serverNames, serverWorldTimes, this.locale.get(GenericLang.UNKNOWN).toString());
    }

    public Pie serverPreferencePie(Map<String, Long> serverPlaytimes) {
        return new ServerPreferencePie(serverPlaytimes);
    }

    public WorldPie worldPie(WorldTimes worldTimes) {
        WorldAliasSettings worldAliasSettings = this.config.getWorldAliasSettings();
        Map<String, Long> playtimePerAlias = worldAliasSettings.getPlaytimePerAlias(worldTimes);
        Map<String, GMTimes> gmTimesPerAlias = worldAliasSettings.getGMTimesPerAlias(worldTimes);
        String[] colors = this.theme.getPieColors(ThemeVal.GRAPH_WORLD_PIE);
        boolean orderByPercentage = this.config.isTrue(DisplaySettings.ORDER_WORLD_PIE_BY_PERC);
        return new WorldPie(playtimePerAlias, gmTimesPerAlias, colors, orderByPercentage);
    }
}

