/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.pie;

import com.djrapitops.plan.delivery.rendering.json.graphs.pie.Pie;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.PieSlice;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ServerPreferencePie
extends Pie {
    ServerPreferencePie(Map<UUID, String> serverNames, Map<UUID, WorldTimes> serverWorldTimes, String unknown) {
        super(ServerPreferencePie.turnToSlices(serverNames, serverWorldTimes, unknown));
    }

    ServerPreferencePie(Map<String, Long> serverPlaytimes) {
        super(ServerPreferencePie.turnToSlices(serverPlaytimes));
    }

    private static List<PieSlice> turnToSlices(Map<UUID, String> serverNames, Map<UUID, WorldTimes> serverWorldTimes, String unknown) {
        ArrayList<PieSlice> slices = new ArrayList<PieSlice>();
        for (Map.Entry<UUID, WorldTimes> server : serverWorldTimes.entrySet()) {
            UUID serverUUID = server.getKey();
            WorldTimes worldTimes = server.getValue();
            String serverName = serverNames.getOrDefault(serverUUID, unknown);
            long num = worldTimes.getTotal();
            slices.add(new PieSlice(serverName, num));
        }
        return slices;
    }

    private static List<PieSlice> turnToSlices(Map<String, Long> serverPlaytimes) {
        ArrayList<PieSlice> slices = new ArrayList<PieSlice>();
        for (Map.Entry<String, Long> server : serverPlaytimes.entrySet()) {
            String serverName = server.getKey();
            long playtime = server.getValue();
            slices.add(new PieSlice(serverName, playtime));
        }
        return slices;
    }
}

