/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.pie;

import com.djrapitops.plan.delivery.rendering.json.graphs.pie.PieSlice;
import com.djrapitops.plan.delivery.rendering.json.graphs.pie.PieWithDrilldown;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.utilities.comparators.PieSliceComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorldPie
extends PieWithDrilldown {
    private final Map<String, GMTimes> gmTimesAliasMap;

    WorldPie(Map<String, Long> playtimePerAlias, Map<String, GMTimes> gmTimesAliasMap, String[] colors, boolean orderByPercentage) {
        super(WorldPie.turnIntoSlices(playtimePerAlias, colors));
        this.gmTimesAliasMap = gmTimesAliasMap;
        if (orderByPercentage) {
            this.slices.sort(new PieSliceComparator());
        }
    }

    private static List<PieSlice> turnIntoSlices(Map<String, Long> playtimePerAlias, String[] colors) {
        int colLength = colors.length;
        ArrayList<String> worlds = new ArrayList<String>(playtimePerAlias.keySet());
        Collections.sort(worlds);
        ArrayList<PieSlice> slices = new ArrayList<PieSlice>();
        int i = 0;
        for (String alias : worlds) {
            Long value = playtimePerAlias.getOrDefault(alias, 0L);
            if (value != 0L) {
                slices.add(new PieSlice(alias, value, colors[i % colLength], true));
            }
            ++i;
        }
        return slices;
    }

    public List<Map<String, Object>> toHighChartsDrillDownMaps() {
        ArrayList<Map<String, Object>> drilldowns = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, GMTimes> worldAlias : this.gmTimesAliasMap.entrySet()) {
            HashMap<String, Object> drilldown = new HashMap<String, Object>();
            drilldown.put("name", worldAlias.getKey());
            drilldown.put("id", worldAlias.getKey());
            drilldown.put("data", this.createGMTimesForWorld(worldAlias.getValue()));
            drilldowns.add(drilldown);
        }
        return drilldowns;
    }

    private List<List<Object>> createGMTimesForWorld(GMTimes gmTimes) {
        ArrayList<List<Object>> data = new ArrayList<List<Object>>();
        for (Map.Entry<String, Long> gmEntry : gmTimes.getTimes().entrySet()) {
            List<Object> gmList = Arrays.asList(gmEntry.getKey(), gmEntry.getValue());
            data.add(gmList);
        }
        return data;
    }
}

