/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.special;

import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;

public class PunchCard {
    private final SessionsMutator sessions;
    private final TimeZone timeZone;

    PunchCard(SessionsMutator sessions, TimeZone timeZone) {
        this.sessions = sessions;
        this.timeZone = timeZone;
    }

    private int[][] getDaysAndHours(Collection<Long> sessionStarts) {
        return (int[][])sessionStarts.stream().map(start -> {
            Calendar day = Calendar.getInstance(this.timeZone);
            day.setTimeInMillis((long)start);
            int hourOfDay = day.get(11);
            int dayOfWeek = day.get(7) - 2;
            if (dayOfWeek > 6) {
                dayOfWeek = 0;
            }
            if (dayOfWeek < 0) {
                dayOfWeek = 6;
            }
            return new int[]{dayOfWeek, hourOfDay};
        }).toArray(x$0 -> new int[x$0][]);
    }

    private int[][] turnIntoMatrix(Collection<Long> sessionStarts) {
        int[][] daysAndHours = this.getDaysAndHours(sessionStarts);
        int[][] matrix = this.createZeroMatrix();
        for (int[] dayAndHour : daysAndHours) {
            int day = dayAndHour[0];
            int hour = dayAndHour[1];
            matrix[day][hour] = matrix[day][hour] + 1;
        }
        return matrix;
    }

    public List<Dot> getDots() {
        ArrayList<Dot> dots = new ArrayList<Dot>();
        List<Long> sessionStarts = this.sessions.toSessionStarts();
        int[][] dayHourMatrix = this.turnIntoMatrix(sessionStarts);
        int big = this.findBiggestValue(dayHourMatrix);
        int[][] scaled = this.scale(dayHourMatrix, big);
        for (int day = 0; day < 7; ++day) {
            for (int hour = 0; hour < 24; ++hour) {
                int value = scaled[day][hour];
                int x = hour * 3600000;
                dots.add(new Dot(x, day, value, value));
            }
        }
        return dots;
    }

    private int[][] createZeroMatrix() {
        int[][] dataArray = new int[7][24];
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 24; ++j) {
                dataArray[i][j] = 0;
            }
        }
        return dataArray;
    }

    private int findBiggestValue(int[][] dataArray) {
        int highest = 1;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 24; ++j) {
                int num = dataArray[i][j];
                if (num <= highest) continue;
                highest = num;
            }
        }
        return highest;
    }

    private int[][] scale(int[][] dataArray, int big) {
        int[][] scaled = new int[7][24];
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 24; ++j) {
                int value = (int)((double)dataArray[i][j] * 10.0 / (double)big);
                if (value != 0) {
                    value += 4;
                }
                scaled[i][j] = value;
            }
        }
        return scaled;
    }

    public static class Dot {
        final int x;
        final int y;
        final int z;
        final Marker marker;

        public Dot(int x, int y, int z, int radius) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.marker = new Marker(radius);
        }

        public String toString() {
            return "{x:" + this.x + ", y:" + this.y + ", z:" + this.z + ", marker:" + this.marker + '}';
        }

        public static class Marker {
            final int radius;

            Marker(int radius) {
                this.radius = radius;
            }

            public String toString() {
                return "{radius:" + this.radius + '}';
            }
        }
    }
}

