/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.stack;

import com.djrapitops.plan.delivery.domain.DateMap;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.rendering.json.graphs.stack.StackDataSet;
import com.djrapitops.plan.delivery.rendering.json.graphs.stack.StackGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

class ActivityStackGraph
extends StackGraph {
    ActivityStackGraph(DateMap<Map<String, Integer>> activityData, String[] colors, Formatter<Long> dayFormatter, String[] groups) {
        super(ActivityStackGraph.getLabels(activityData.navigableKeySet(), dayFormatter), ActivityStackGraph.getDataSets(activityData, colors, groups));
    }

    private static String[] getLabels(Collection<Long> dates, Formatter<Long> dayFormatter) {
        return (String[])dates.stream().map(dayFormatter).toArray(String[]::new);
    }

    private static StackDataSet[] initializeDataSet(String[] groups, String[] colors) {
        int maxCol = colors.length;
        StackDataSet[] dataSets = new StackDataSet[groups.length];
        for (int i = 0; i < groups.length; ++i) {
            dataSets[i] = new StackDataSet(new ArrayList<Double>(), groups[i], colors[i % maxCol]);
        }
        return dataSets;
    }

    private static StackDataSet[] getDataSets(DateMap<Map<String, Integer>> activityData, String[] colors, String[] groups) {
        StackDataSet[] dataSets = ActivityStackGraph.initializeDataSet(groups, colors);
        String[] defaultGroups = ActivityIndex.getDefaultGroups();
        for (Map data : activityData.values()) {
            for (int j = 0; j < groups.length; ++j) {
                dataSets[j].add(data.getOrDefault(defaultGroups[j], 0).intValue());
            }
        }
        return dataSets;
    }
}

