/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.graphs.stack;

import com.djrapitops.plan.delivery.domain.DateMap;
import com.djrapitops.plan.delivery.domain.mutators.ActivityIndex;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.graphs.stack.ActivityStackGraph;
import com.djrapitops.plan.delivery.rendering.json.graphs.stack.StackGraph;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import java.util.Map;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class StackGraphFactory {
    private final Locale locale;
    private final Theme theme;
    private final Formatter<Long> dayFormatter;

    @Inject
    public StackGraphFactory(Locale locale, Formatters formatters, Theme theme) {
        this.locale = locale;
        this.theme = theme;
        this.dayFormatter = formatters.dayLong();
    }

    public StackGraph activityStackGraph(DateMap<Map<String, Integer>> activityData) {
        String[] colors = this.theme.getPieColors(ThemeVal.GRAPH_ACTIVITY_PIE);
        return new ActivityStackGraph(activityData, colors, this.dayFormatter, ActivityIndex.getGroups(this.locale));
    }
}

