/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.network;

import com.djrapitops.plan.delivery.domain.DateHolder;
import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.Trend;
import com.djrapitops.plan.delivery.rendering.json.network.NetworkTabJSONCreator;
import com.djrapitops.plan.gathering.ServerSensor;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.analysis.NetworkActivityIndexQueries;
import com.djrapitops.plan.storage.database.queries.analysis.PlayerCountQueries;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NetworkOverviewJSONCreator
implements NetworkTabJSONCreator<Map<String, Object>> {
    private final Formatter<Long> day;
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final ServerSensor<?> serverSensor;
    private final Formatter<Long> timeAmount;
    private final Formatter<DateHolder> year;

    @Inject
    public NetworkOverviewJSONCreator(PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, ServerSensor<?> serverSensor, Formatters formatters) {
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.serverSensor = serverSensor;
        this.year = formatters.year();
        this.day = formatters.dayLong();
        this.timeAmount = formatters.timeAmount();
    }

    @Override
    public Map<String, Object> createJSONAsMap() {
        HashMap<String, Object> serverOverview = new HashMap<String, Object>();
        serverOverview.put("players", this.createPlayersMap());
        serverOverview.put("numbers", this.createNumbersMap());
        serverOverview.put("weeks", this.createWeeksMap());
        return serverOverview;
    }

    private Map<String, Object> createPlayersMap() {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long dayAgo = now - TimeUnit.DAYS.toMillis(1L);
        long weekAgo = now - TimeUnit.DAYS.toMillis(7L);
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        HashMap<String, Object> sevenDays = new HashMap<String, Object>();
        sevenDays.put("unique_players_1d", db.query(PlayerCountQueries.uniquePlayerCount(dayAgo, now)));
        sevenDays.put("unique_players_7d", db.query(PlayerCountQueries.uniquePlayerCount(weekAgo, now)));
        sevenDays.put("unique_players_30d", db.query(PlayerCountQueries.uniquePlayerCount(monthAgo, now)));
        sevenDays.put("new_players_1d", db.query(PlayerCountQueries.newPlayerCount(dayAgo, now)));
        sevenDays.put("new_players_7d", db.query(PlayerCountQueries.newPlayerCount(weekAgo, now)));
        sevenDays.put("new_players_30d", db.query(PlayerCountQueries.newPlayerCount(monthAgo, now)));
        return sevenDays;
    }

    private Map<String, Object> createNumbersMap() {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long twoDaysAgo = now - TimeUnit.DAYS.toMillis(2L);
        Long playtimeThreshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        HashMap<String, Object> numbers = new HashMap<String, Object>();
        Integer userCount = db.query(PlayerCountQueries.newPlayerCount(0L, now));
        numbers.put("total_players", userCount);
        numbers.put("regular_players", db.query(NetworkActivityIndexQueries.fetchRegularPlayerCount(now, playtimeThreshold)));
        numbers.put("online_players", this.serverSensor.getOnlinePlayerCount());
        UUID serverUUID = this.serverInfo.getServerUUID();
        Optional<DateObj<Integer>> lastPeak = db.query(TPSQueries.fetchPeakPlayerCount(serverUUID, twoDaysAgo));
        Optional<DateObj<Integer>> allTimePeak = db.query(TPSQueries.fetchAllTimePeakPlayerCount(serverUUID));
        numbers.put("last_peak_date", lastPeak.map(this.year).orElse("-"));
        numbers.put("last_peak_players", lastPeak.map(dateObj -> ((Integer)dateObj.getValue()).toString()).orElse("-"));
        numbers.put("best_peak_date", allTimePeak.map(this.year).orElse("-"));
        numbers.put("best_peak_players", allTimePeak.map(dateObj -> ((Integer)dateObj.getValue()).toString()).orElse("-"));
        Long totalPlaytime = db.query(SessionQueries.playtime(0L, now));
        numbers.put("playtime", this.timeAmount.apply(totalPlaytime));
        numbers.put("player_playtime", userCount != 0 ? this.timeAmount.apply(totalPlaytime / (long)userCount.intValue()) : "-");
        Long sessionCount = db.query(SessionQueries.sessionCount(0L, now));
        numbers.put("sessions", sessionCount);
        numbers.put("session_length_avg", sessionCount != 0L ? this.timeAmount.apply(totalPlaytime / sessionCount) : "-");
        return numbers;
    }

    private Map<String, Object> createWeeksMap() {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long oneWeekAgo = now - TimeUnit.DAYS.toMillis(7L);
        long twoWeeksAgo = now - TimeUnit.DAYS.toMillis(14L);
        Long playtimeThreshold = this.config.get(TimeSettings.ACTIVE_PLAY_THRESHOLD);
        HashMap<String, Object> weeks = new HashMap<String, Object>();
        weeks.put("start", this.day.apply(twoWeeksAgo));
        weeks.put("midpoint", this.day.apply(oneWeekAgo));
        weeks.put("end", this.day.apply(now));
        Integer uniqueBefore = db.query(PlayerCountQueries.uniquePlayerCount(twoWeeksAgo, oneWeekAgo));
        Integer uniqueAfter = db.query(PlayerCountQueries.uniquePlayerCount(oneWeekAgo, now));
        Trend uniqueTrend = new Trend(uniqueBefore.intValue(), uniqueAfter.intValue(), false);
        weeks.put("unique_before", uniqueBefore);
        weeks.put("unique_after", uniqueAfter);
        weeks.put("unique_trend", uniqueTrend);
        Integer newBefore = db.query(PlayerCountQueries.newPlayerCount(twoWeeksAgo, oneWeekAgo));
        Integer newAfter = db.query(PlayerCountQueries.newPlayerCount(oneWeekAgo, now));
        Trend newTrend = new Trend(newBefore.intValue(), newAfter.intValue(), false);
        weeks.put("new_before", newBefore);
        weeks.put("new_after", newAfter);
        weeks.put("new_trend", newTrend);
        int regularBefore = db.query(NetworkActivityIndexQueries.fetchRegularPlayerCount(oneWeekAgo, playtimeThreshold));
        int regularAfter = db.query(NetworkActivityIndexQueries.fetchRegularPlayerCount(now, playtimeThreshold));
        weeks.put("regular_before", regularBefore);
        weeks.put("regular_after", regularAfter);
        weeks.put("regular_trend", new Trend(regularBefore, regularAfter, false));
        Long playtimeBefore = db.query(SessionQueries.playtime(twoWeeksAgo, oneWeekAgo));
        Long playtimeAfter = db.query(SessionQueries.playtime(oneWeekAgo, now));
        long avgPlaytimeBefore = uniqueBefore != 0 ? playtimeBefore / (long)uniqueBefore.intValue() : 0L;
        long avgPlaytimeAfter = uniqueAfter != 0 ? playtimeAfter / (long)uniqueAfter.intValue() : 0L;
        Trend avgPlaytimeTrend = new Trend(avgPlaytimeBefore, avgPlaytimeAfter, false, this.timeAmount);
        weeks.put("average_playtime_before", this.timeAmount.apply(avgPlaytimeBefore));
        weeks.put("average_playtime_after", this.timeAmount.apply(avgPlaytimeAfter));
        weeks.put("average_playtime_trend", avgPlaytimeTrend);
        Long sessionsBefore = db.query(SessionQueries.sessionCount(twoWeeksAgo, oneWeekAgo));
        Long sessionsAfter = db.query(SessionQueries.sessionCount(oneWeekAgo, now));
        Trend sessionsTrend = new Trend(sessionsBefore, sessionsAfter, false);
        weeks.put("sessions_before", sessionsBefore);
        weeks.put("sessions_after", sessionsAfter);
        weeks.put("sessions_trend", sessionsTrend);
        long avgSessionLengthBefore = sessionsBefore != 0L ? playtimeBefore / sessionsBefore : 0L;
        long avgSessionLengthAfter = sessionsAfter != 0L ? playtimeAfter / sessionsAfter : 0L;
        Trend avgSessionLengthTrend = new Trend(avgSessionLengthBefore, avgSessionLengthAfter, false, this.timeAmount);
        weeks.put("session_length_average_before", this.timeAmount.apply(avgSessionLengthBefore));
        weeks.put("session_length_average_after", this.timeAmount.apply(avgSessionLengthAfter));
        weeks.put("session_length_average_trend", avgSessionLengthTrend);
        return weeks;
    }
}

