/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.json.network;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.json.network.NetworkTabJSONCreator;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NetworkSessionsOverviewJSONCreator
implements NetworkTabJSONCreator<Map<String, Object>> {
    private final DBSystem dbSystem;
    private final Formatter<Long> timeAmount;
    private final Formatter<Double> percentage;

    @Inject
    public NetworkSessionsOverviewJSONCreator(DBSystem dbSystem, Formatters formatters) {
        this.dbSystem = dbSystem;
        this.timeAmount = formatters.timeAmount();
        this.percentage = formatters.percentage();
    }

    @Override
    public Map<String, Object> createJSONAsMap() {
        return Collections.singletonMap("insights", this.createInsightsMap());
    }

    private Map<String, Object> createInsightsMap() {
        Database db = this.dbSystem.getDatabase();
        long now = System.currentTimeMillis();
        long monthAgo = now - TimeUnit.DAYS.toMillis(30L);
        HashMap<String, Object> insights = new HashMap<String, Object>();
        Long playtime = db.query(SessionQueries.playtime(monthAgo, now));
        Long afkTime = db.query(SessionQueries.afkTime(monthAgo, now));
        insights.put("total_playtime", this.timeAmount.apply(playtime));
        insights.put("afk_time", this.timeAmount.apply(afkTime));
        insights.put("afk_time_perc", playtime != 0L ? this.percentage.apply(1.0 * (double)afkTime.longValue() / (double)playtime.longValue()) : "-");
        return insights;
    }
}

