/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.formatting.PlaceholderReplacer;
import com.djrapitops.plan.delivery.rendering.html.Contributors;
import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import com.djrapitops.plan.delivery.rendering.html.structure.TabsElement;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.identification.properties.ServerProperties;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.file.ResourceCache;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plan.version.VersionChecker;
import com.djrapitops.plugin.benchmarking.Benchmark;
import com.djrapitops.plugin.benchmarking.Timings;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.debug.CombineDebugLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import com.djrapitops.plugin.logging.debug.MemoryDebugLogger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;

public class DebugPage
implements Page {
    private final String template;
    private final Database database;
    private final ServerInfo serverInfo;
    private final VersionChecker versionChecker;
    private final CombineDebugLogger debugLogger;
    private final Timings timings;
    private final ErrorLogger errorLogger;
    private final Formatter<Long> yearFormatter;

    DebugPage(String htmlTemplate, Database database, ServerInfo serverInfo, Formatters formatters, VersionChecker versionChecker, DebugLogger debugLogger, Timings timings, ErrorLogger errorLogger) {
        this.template = htmlTemplate;
        this.database = database;
        this.serverInfo = serverInfo;
        this.versionChecker = versionChecker;
        this.debugLogger = (CombineDebugLogger)debugLogger;
        this.timings = timings;
        this.errorLogger = errorLogger;
        this.yearFormatter = formatters.yearLong();
    }

    @Override
    public String toHtml() {
        PlaceholderReplacer placeholders = new PlaceholderReplacer();
        placeholders.put("title", Icon.called("bug") + " Debug Information");
        placeholders.put("titleText", "Debug Information");
        placeholders.put("paragraph", this.createContent());
        placeholders.put("version", this.versionChecker.getUpdateButton().orElse(this.versionChecker.getCurrentVersionButton()));
        placeholders.put("updateModal", this.versionChecker.getUpdateModal());
        placeholders.put("contributors", Contributors.generateContributorHtml());
        return placeholders.apply(this.template);
    }

    private String createContent() {
        StringBuilder preContent = new StringBuilder();
        String issueLink = Html.LINK_EXTERNAL.create(new Serializable[]{"https://github.com/Rsl1122/Plan-PlayerAnalytics/issues/new", "Create new issue on Github"});
        String hastebinLink = Html.LINK_EXTERNAL.create(new Serializable[]{"https://hastebin.com/", "Create a new hastebin paste"});
        preContent.append("<p>").append(Html.separateWithDots(issueLink, hastebinLink)).append("<br><br>").append("This page contains debug information for an issue ticket. You can copy it directly into the issue, the info is pre-formatted.").append("</p>");
        TabsElement.Tab info = new TabsElement.Tab(Icon.called("server") + " Server Information", this.createServerInfoContent());
        TabsElement.Tab errors = new TabsElement.Tab(Icon.called("exclamation-circle") + " Errors", this.createErrorContent());
        TabsElement.Tab debugLog = new TabsElement.Tab(Icon.called("bug") + " Debug Log", this.createDebugLogContent());
        TabsElement.Tab caches = new TabsElement.Tab(Icon.called("archive") + " Plan Caches", this.createCacheContent());
        TabsElement tabs = new TabsElement(info, errors, debugLog, caches);
        return preContent + tabs.toHtmlFull();
    }

    private String createCacheContent() {
        StringBuilder content = new StringBuilder();
        this.appendResourceCache(content);
        this.appendJSONCache(content);
        this.appendSessionCache(content);
        return content.toString();
    }

    private void appendResourceCache(StringBuilder content) {
        try {
            content.append("<pre>### Cached Resources (from File or Jar):<br><br>");
            List<String> cacheKeys = ResourceCache.getCachedResourceNames();
            if (cacheKeys.isEmpty()) {
                content.append("Empty");
            }
            for (String cacheKey : cacheKeys) {
                content.append("- ").append(cacheKey).append("<br>");
            }
            content.append("</pre>");
        }
        catch (Exception e) {
            this.errorLogger.log(L.WARN, e, ErrorContext.builder().related((Object)"/debug page access, resource cache").build());
        }
    }

    private void appendJSONCache(StringBuilder content) {
        try {
            content.append("<pre>### Cached JSON:<br><br>");
            List<String> cacheKeys = JSONCache.getCachedIDs();
            if (cacheKeys.isEmpty()) {
                content.append("Empty");
            }
            for (String cacheKey : cacheKeys) {
                content.append("- ").append(cacheKey).append("<br>");
            }
            content.append("</pre>");
        }
        catch (Exception e) {
            this.errorLogger.log(L.WARN, e, ErrorContext.builder().related((Object)"/debug page access, JSON cache").build());
        }
    }

    private void appendSessionCache(StringBuilder content) {
        try {
            content.append("<pre>### Session Cache:<br><br>");
            content.append("Name | Session Started <br>").append("-- | -- <br>");
            Set<Map.Entry<UUID, Session>> sessions = SessionCache.getActiveSessions().entrySet();
            if (sessions.isEmpty()) {
                content.append("Empty");
            }
            for (Map.Entry<UUID, Session> entry : sessions) {
                Session session = entry.getValue();
                String name = session.getValue(SessionKeys.NAME).orElse(entry.getKey().toString());
                String start = session.getValue(SessionKeys.START).map(this.yearFormatter).orElse("Unknown");
                content.append(name).append(" | ").append(start).append("<br>");
            }
            content.append("</pre>");
        }
        catch (Exception e) {
            this.errorLogger.log(L.WARN, e, ErrorContext.builder().related((Object)"/debug page access, Session cache").build());
        }
    }

    private String createDebugLogContent() {
        StringBuilder content = new StringBuilder();
        this.appendDebugLog(content);
        return content.toString();
    }

    private String createErrorContent() {
        StringBuilder content = new StringBuilder();
        this.appendLoggedErrors(content);
        return content.toString();
    }

    private String createServerInfoContent() {
        StringBuilder content = new StringBuilder();
        this.appendServerInformation(content);
        this.appendBenchmarks(content);
        return content.toString();
    }

    private void appendServerInformation(StringBuilder content) {
        ServerProperties serverProperties = this.serverInfo.getServerProperties();
        content.append("<pre>### Server Information<br>").append("**Plan Version:** ").append(this.versionChecker.getCurrentVersion()).append("<br>");
        content.append("**Server:** ");
        content.append(serverProperties.getName()).append(" ").append(serverProperties.getImplVersion()).append(" (").append(serverProperties.getVersion());
        content.append(")<br>");
        content.append("**Database:** ").append(this.database.getType().getName());
        content.append("<br><br>");
        Properties properties = System.getProperties();
        String osName = properties.getProperty("os.name");
        String osVersion = properties.getProperty("os.version");
        String osArch = properties.getProperty("os.arch");
        String javaVendor = properties.getProperty("java.vendor");
        String javaVersion = properties.getProperty("java.version");
        String javaVMVendor = properties.getProperty("java.vm.vendor");
        String javaVMName = properties.getProperty("java.vm.name");
        String javaVMVersion = properties.getProperty("java.vm.version");
        content.append("**Operating SubSystem:** ").append(osName).append(" (").append(osArch).append(") version ").append(osVersion).append("<br>");
        content.append("**Java Version:** ").append(javaVersion).append(", ").append(javaVendor).append("<br>");
        content.append("**Java VM Version:** ").append(javaVMName).append(" version ").append(javaVMVersion).append(", ").append(javaVMVendor).append("<br>");
        content.append("</pre>");
    }

    private void appendBenchmarks(StringBuilder content) {
        content.append("<pre>### Benchmarks<br>&#96;&#96;&#96;<br>");
        try {
            for (Benchmark result : this.timings.getAverageResults()) {
                content.append(result.toString()).append("<br>");
            }
        }
        catch (Exception e) {
            content.append("Exception on Timings#getAverageResults");
        }
        content.append("&#96;&#96;&#96;</pre>");
    }

    private void appendLoggedErrors(StringBuilder content) {
        content.append("<pre>### Logged Errors<br>");
        content.append("Using incompatible ErrorHandler");
        content.append("</pre>");
    }

    private void appendDebugLog(StringBuilder content) {
        Optional<MemoryDebugLogger> memoryDebugLogger = this.debugLogger.getDebugLogger(MemoryDebugLogger.class);
        Map channels = memoryDebugLogger.map(MemoryDebugLogger::getChannels).orElse(new HashMap());
        if (channels.isEmpty()) {
            content.append("Incompatible Debug Logger in use (No MemoryDebugLogger)");
            return;
        }
        TabsElement.Tab[] tabs = (TabsElement.Tab[])channels.entrySet().stream().sorted((one, two) -> String.CASE_INSENSITIVE_ORDER.compare(one.getKey(), two.getKey())).map(channel -> {
            String name = ((String)channel.getKey()).isEmpty() ? "Default" : (String)channel.getKey();
            return new TabsElement.Tab(name, this.debugChannelContent(name, (List)channel.getValue()));
        }).toArray(TabsElement.Tab[]::new);
        content.append(new TabsElement(tabs).toHtmlFull());
    }

    private String debugChannelContent(String channelName, List<String> lines) {
        StringBuilder content = new StringBuilder();
        content.append("<pre>### Debug (").append(channelName).append(")<br>&#96;&#96;&#96;<br>");
        for (String line : lines) {
            content.append(line).append("<br>");
        }
        content.append("&#96;&#96;&#96;</pre>");
        return content.toString();
    }
}

