/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.formatting.PlaceholderReplacer;
import com.djrapitops.plan.delivery.rendering.html.Contributors;
import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.utilities.java.UnaryChain;
import com.djrapitops.plan.version.VersionChecker;

public class ErrorMessagePage
implements Page {
    private final String template;
    private final Icon icon;
    private final String errorTitle;
    private final String errorMsg;
    private final Locale locale;
    private final Theme theme;
    private final VersionChecker versionChecker;

    public ErrorMessagePage(String template, Icon icon, String errorTitle, String errorMsg, Locale locale, Theme theme, VersionChecker versionChecker) {
        this.template = template;
        this.icon = icon;
        this.errorTitle = errorTitle;
        this.errorMsg = errorMsg;
        this.locale = locale;
        this.theme = theme;
        this.versionChecker = versionChecker;
    }

    public ErrorMessagePage(String template, String errorTitle, String errorMsg, VersionChecker versionChecker, Locale locale, Theme theme) {
        this(template, Icon.called("exclamation-circle").build(), errorTitle, errorMsg, locale, theme, versionChecker);
    }

    @Override
    public String toHtml() {
        PlaceholderReplacer placeholders = new PlaceholderReplacer();
        placeholders.put("title", this.icon.toHtml() + " " + this.errorTitle);
        placeholders.put("titleText", this.errorTitle);
        placeholders.put("paragraph", this.errorMsg);
        placeholders.put("version", this.versionChecker.getUpdateButton().orElse(this.versionChecker.getCurrentVersionButton()));
        placeholders.put("updateModal", this.versionChecker.getUpdateModal());
        placeholders.put("contributors", Contributors.generateContributorHtml());
        return UnaryChain.of(this.template).chain(this.theme::replaceThemeColors).chain(placeholders::apply).chain(this.locale::replaceLanguageInHtml).apply();
    }
}

