/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.formatting.PlaceholderReplacer;
import com.djrapitops.plan.delivery.rendering.html.Contributors;
import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.version.VersionChecker;
import java.io.Serializable;

public class InternalErrorPage
implements Page {
    private final String template;
    private final String errorMsg;
    private final Throwable error;
    private final VersionChecker versionChecker;

    public InternalErrorPage(String template, String errorMsg, Throwable error, VersionChecker versionChecker) {
        this.template = template;
        this.errorMsg = errorMsg;
        this.error = error;
        this.versionChecker = versionChecker;
    }

    @Override
    public String toHtml() {
        PlaceholderReplacer placeholders = new PlaceholderReplacer();
        placeholders.put("title", Icon.called("bug") + " 500 Internal Error occurred");
        placeholders.put("titleText", "500 Internal Error occurred");
        placeholders.put("paragraph", this.createContent());
        placeholders.put("version", this.versionChecker.getUpdateButton().orElse(this.versionChecker.getCurrentVersionButton()));
        placeholders.put("updateModal", this.versionChecker.getUpdateModal());
        placeholders.put("contributors", Contributors.generateContributorHtml());
        return placeholders.apply(this.template);
    }

    private String createContent() {
        StringBuilder paragraph = new StringBuilder();
        paragraph.append("Please report this issue here: ");
        paragraph.append(Html.LINK.create(new Serializable[]{"https://github.com/Rsl1122/Plan-PlayerAnalytics/issues", "Issues"}));
        paragraph.append("<br><br><pre>");
        paragraph.append(this.error).append(" | ").append(this.errorMsg);
        for (StackTraceElement element : this.error.getStackTrace()) {
            paragraph.append("<br>");
            paragraph.append("    ").append(element);
        }
        if (this.error.getCause() != null) {
            this.appendCause(this.error.getCause(), paragraph);
        }
        paragraph.append("</pre>");
        return paragraph.toString();
    }

    private void appendCause(Throwable cause, StringBuilder paragraph) {
        paragraph.append("<br>Caused by: ").append(cause);
        for (StackTraceElement element : cause.getStackTrace()) {
            paragraph.append("<br>");
            paragraph.append("    ").append(element);
        }
        if (cause.getCause() != null) {
            this.appendCause(cause.getCause(), paragraph);
        }
    }
}

