/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.domain.container.CachingSupplier;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.formatting.PlaceholderReplacer;
import com.djrapitops.plan.delivery.rendering.html.Contributors;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.delivery.rendering.pages.ServerPluginTabs;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.storage.queries.ExtensionServerDataQuery;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.ProxySettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.utilities.java.UnaryChain;
import com.djrapitops.plan.version.VersionChecker;
import java.util.List;
import java.util.UUID;
import plan.org.apache.commons.lang3.StringUtils;

public class NetworkPage
implements Page {
    private final String templateHtml;
    private final DBSystem dbSystem;
    private final VersionChecker versionChecker;
    private final PlanConfig config;
    private final Theme theme;
    private final Locale locale;
    private final ServerInfo serverInfo;
    private final Formatters formatters;

    NetworkPage(String templateHtml, DBSystem dbSystem, VersionChecker versionChecker, PlanConfig config, Theme theme, Locale locale, ServerInfo serverInfo, Formatters formatters) {
        this.templateHtml = templateHtml;
        this.dbSystem = dbSystem;
        this.versionChecker = versionChecker;
        this.config = config;
        this.theme = theme;
        this.locale = locale;
        this.serverInfo = serverInfo;
        this.formatters = formatters;
    }

    @Override
    public String toHtml() {
        PlaceholderReplacer placeholders = new PlaceholderReplacer();
        UUID serverUUID = this.serverInfo.getServerUUID();
        placeholders.put("networkDisplayName", this.config.get(ProxySettings.NETWORK_NAME));
        placeholders.put("serverName", this.config.get(ProxySettings.NETWORK_NAME));
        placeholders.put("serverUUID", serverUUID.toString());
        placeholders.put("gmPieColors", this.theme.getValue(ThemeVal.GRAPH_GM_PIE));
        placeholders.put("playersGraphColor", this.theme.getValue(ThemeVal.GRAPH_PLAYERS_ONLINE));
        placeholders.put("worldMapColLow", this.theme.getValue(ThemeVal.WORLD_MAP_LOW));
        placeholders.put("worldMapColHigh", this.theme.getValue(ThemeVal.WORLD_MAP_HIGH));
        placeholders.put("maxPingColor", this.theme.getValue(ThemeVal.GRAPH_MAX_PING));
        placeholders.put("minPingColor", this.theme.getValue(ThemeVal.GRAPH_MIN_PING));
        placeholders.put("avgPingColor", this.theme.getValue(ThemeVal.GRAPH_AVG_PING));
        placeholders.put("timeZone", this.config.getTimeZoneOffsetHours());
        placeholders.put("version", this.versionChecker.getUpdateButton().orElse(this.versionChecker.getCurrentVersionButton()));
        placeholders.put("updateModal", this.versionChecker.getUpdateModal());
        placeholders.put("contributors", Contributors.generateContributorHtml());
        CachingSupplier<ServerPluginTabs> pluginTabs = new CachingSupplier<ServerPluginTabs>(() -> {
            List<ExtensionData> extensionData = this.dbSystem.getDatabase().query(new ExtensionServerDataQuery(serverUUID));
            return new ServerPluginTabs(extensionData, this.formatters);
        });
        String nav = JSONCache.getOrCacheString(DataID.EXTENSION_NAV, serverUUID, () -> ((ServerPluginTabs)pluginTabs.get()).getNav());
        String tabs = JSONCache.getOrCacheString(DataID.EXTENSION_TABS, serverUUID, () -> ((ServerPluginTabs)pluginTabs.get()).getTabs());
        PlaceholderReplacer pluginPlaceholders = new PlaceholderReplacer();
        pluginPlaceholders.put("networkDisplayName", this.config.get(ProxySettings.NETWORK_NAME));
        pluginPlaceholders.put("serverName", this.config.get(ProxySettings.NETWORK_NAME));
        pluginPlaceholders.put("serverUUID", serverUUID.toString());
        pluginPlaceholders.put("navPluginsTabs", nav);
        pluginPlaceholders.put("tabsPlugins", StringUtils.remove(tabs, "${backButton}"));
        return UnaryChain.of(this.templateHtml).chain(this.theme::replaceThemeColors).chain(placeholders::apply).chain(pluginPlaceholders::apply).chain(this.locale::replaceLanguageInHtml).apply();
    }
}

