/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import com.djrapitops.plan.delivery.rendering.pages.DebugPage;
import com.djrapitops.plan.delivery.rendering.pages.ErrorMessagePage;
import com.djrapitops.plan.delivery.rendering.pages.InternalErrorPage;
import com.djrapitops.plan.delivery.rendering.pages.LoginPage;
import com.djrapitops.plan.delivery.rendering.pages.NetworkPage;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.delivery.rendering.pages.PlayerPage;
import com.djrapitops.plan.delivery.rendering.pages.PlayerPluginTab;
import com.djrapitops.plan.delivery.rendering.pages.PlayersPage;
import com.djrapitops.plan.delivery.rendering.pages.ServerPage;
import com.djrapitops.plan.delivery.web.ResourceService;
import com.djrapitops.plan.delivery.web.resolver.exception.NotFoundException;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.storage.queries.ExtensionPlayerDataQuery;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.containers.ContainerFetchQueries;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plan.version.VersionChecker;
import com.djrapitops.plugin.benchmarking.Timings;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PageFactory {
    private final Lazy<VersionChecker> versionChecker;
    private final Lazy<PlanFiles> files;
    private final Lazy<PlanConfig> config;
    private final Lazy<Locale> locale;
    private final Lazy<Theme> theme;
    private final Lazy<DBSystem> dbSystem;
    private final Lazy<ServerInfo> serverInfo;
    private final Lazy<Formatters> formatters;
    private final Lazy<DebugLogger> debugLogger;
    private final Lazy<Timings> timings;
    private final Lazy<ErrorLogger> errorLogger;

    @Inject
    public PageFactory(Lazy<VersionChecker> versionChecker, Lazy<PlanFiles> files, Lazy<PlanConfig> config, Lazy<Locale> locale, Lazy<Theme> theme, Lazy<DBSystem> dbSystem, Lazy<ServerInfo> serverInfo, Lazy<Formatters> formatters, Lazy<DebugLogger> debugLogger, Lazy<Timings> timings, Lazy<ErrorLogger> errorLogger) {
        this.versionChecker = versionChecker;
        this.files = files;
        this.config = config;
        this.locale = locale;
        this.theme = theme;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.formatters = formatters;
        this.debugLogger = debugLogger;
        this.timings = timings;
        this.errorLogger = errorLogger;
    }

    public DebugPage debugPage() throws IOException {
        return new DebugPage(this.getResource("error.html"), this.dbSystem.get().getDatabase(), this.serverInfo.get(), this.formatters.get(), this.versionChecker.get(), this.debugLogger.get(), this.timings.get(), this.errorLogger.get());
    }

    public PlayersPage playersPage() throws IOException {
        return new PlayersPage(this.getResource("players.html"), this.versionChecker.get(), this.config.get(), this.locale.get(), this.theme.get(), this.serverInfo.get());
    }

    public Page serverPage(UUID serverUUID) throws IOException {
        Server server = this.dbSystem.get().getDatabase().query(ServerQueries.fetchServerMatchingIdentifier(serverUUID)).orElseThrow(() -> new NotFoundException("Server not found in the database"));
        return new ServerPage(this.getResource("server.html"), server, this.config.get(), this.theme.get(), this.locale.get(), this.versionChecker.get(), this.dbSystem.get(), this.serverInfo.get(), this.formatters.get());
    }

    public PlayerPage playerPage(UUID playerUUID) throws IOException {
        Database db = this.dbSystem.get().getDatabase();
        PlayerContainer player = db.query(ContainerFetchQueries.fetchPlayerContainer(playerUUID));
        return new PlayerPage(this.getResource("player.html"), player, this.versionChecker.get(), this.config.get(), this, this.theme.get(), this.locale.get(), this.formatters.get(), this.serverInfo.get());
    }

    public PlayerPluginTab inspectPluginTabs(UUID playerUUID) {
        Database database = this.dbSystem.get().getDatabase();
        Map<UUID, List<ExtensionData>> extensionPlayerData = database.query(new ExtensionPlayerDataQuery(playerUUID));
        if (extensionPlayerData.isEmpty()) {
            return new PlayerPluginTab("", Collections.emptyList(), this.formatters.get());
        }
        ArrayList<PlayerPluginTab> playerPluginTabs = new ArrayList<PlayerPluginTab>();
        for (Map.Entry<UUID, Server> entry : database.query(ServerQueries.fetchPlanServerInformation()).entrySet()) {
            UUID serverUUID = entry.getKey();
            String serverName = entry.getValue().getIdentifiableName();
            List<ExtensionData> ofServer = extensionPlayerData.get(serverUUID);
            if (ofServer == null) continue;
            playerPluginTabs.add(new PlayerPluginTab(serverName, ofServer, this.formatters.get()));
        }
        StringBuilder navs = new StringBuilder();
        StringBuilder tabs = new StringBuilder();
        playerPluginTabs.stream().sorted().forEach(tab -> {
            navs.append(tab.getNav());
            tabs.append(tab.getTab());
        });
        return new PlayerPluginTab(navs.toString(), tabs.toString());
    }

    public NetworkPage networkPage() throws IOException {
        return new NetworkPage(this.getResource("network.html"), this.dbSystem.get(), this.versionChecker.get(), this.config.get(), this.theme.get(), this.locale.get(), this.serverInfo.get(), this.formatters.get());
    }

    public Page internalErrorPage(String message, Throwable error) {
        try {
            return new InternalErrorPage(this.getResource("error.html"), message, error, this.versionChecker.get());
        }
        catch (IOException noParse) {
            return () -> "Error occurred: " + error.toString() + ", additional error occurred when attempting to render error page to user: " + noParse.toString();
        }
    }

    public Page errorPage(String title, String error) throws IOException {
        return new ErrorMessagePage(this.getResource("error.html"), title, error, this.versionChecker.get(), this.locale.get(), this.theme.get());
    }

    public Page errorPage(Icon icon, String title, String error) throws IOException {
        return new ErrorMessagePage(this.getResource("error.html"), icon, title, error, this.locale.get(), this.theme.get(), this.versionChecker.get());
    }

    public String getResource(String name) throws IOException {
        try {
            return ResourceService.getInstance().getResource("Plan", name, () -> this.files.get().getResourceFromJar("web/" + name).asWebResource()).asString();
        }
        catch (UncheckedIOException readFail) {
            throw readFail.getCause();
        }
    }

    public Page loginPage() throws IOException {
        return new LoginPage(this.getResource("login.html"), this.serverInfo.get());
    }

    public Page registerPage() throws IOException {
        return new LoginPage(this.getResource("register.html"), this.serverInfo.get());
    }
}

