/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.formatting.PlaceholderReplacer;
import com.djrapitops.plan.delivery.rendering.html.Contributors;
import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.delivery.rendering.pages.PageFactory;
import com.djrapitops.plan.delivery.rendering.pages.PlayerPluginTab;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import com.djrapitops.plan.utilities.java.UnaryChain;
import com.djrapitops.plan.version.VersionChecker;
import java.util.UUID;

public class PlayerPage
implements Page {
    private final String templateHtml;
    private final PlayerContainer player;
    private final VersionChecker versionChecker;
    private final PlanConfig config;
    private final PageFactory pageFactory;
    private final Theme theme;
    private final Locale locale;
    private final ServerInfo serverInfo;
    private final Formatter<Long> clockLongFormatter;
    private final Formatter<Long> secondLongFormatter;

    PlayerPage(String templateHtml, PlayerContainer player, VersionChecker versionChecker, PlanConfig config, PageFactory pageFactory, Theme theme, Locale locale, Formatters formatters, ServerInfo serverInfo) {
        this.templateHtml = templateHtml;
        this.player = player;
        this.versionChecker = versionChecker;
        this.config = config;
        this.pageFactory = pageFactory;
        this.theme = theme;
        this.locale = locale;
        this.serverInfo = serverInfo;
        this.clockLongFormatter = formatters.clockLong();
        this.secondLongFormatter = formatters.secondLong();
    }

    @Override
    public String toHtml() {
        if (!this.player.getValue(PlayerKeys.REGISTERED).isPresent()) {
            throw new IllegalStateException("Player is not registered");
        }
        return this.createFor(this.player);
    }

    public String createFor(PlayerContainer player) {
        long now = System.currentTimeMillis();
        UUID playerUUID = player.getUnsafe(PlayerKeys.UUID);
        PlaceholderReplacer placeholders = new PlaceholderReplacer();
        placeholders.put("refresh", this.clockLongFormatter.apply(now));
        placeholders.put("refreshFull", this.secondLongFormatter.apply(now));
        placeholders.put("version", this.versionChecker.getUpdateButton().orElse(this.versionChecker.getCurrentVersionButton()));
        placeholders.put("updateModal", this.versionChecker.getUpdateModal());
        String playerName = player.getValue(PlayerKeys.NAME).orElse(playerUUID.toString());
        placeholders.put("playerName", playerName);
        placeholders.put("timeZone", this.config.getTimeZoneOffsetHours());
        placeholders.put("gmPieColors", this.theme.getValue(ThemeVal.GRAPH_GM_PIE));
        placeholders.put("contributors", Contributors.generateContributorHtml());
        PlaceholderReplacer pluginPlaceholders = new PlaceholderReplacer();
        PlayerPluginTab pluginTabs = this.pageFactory.inspectPluginTabs(playerUUID);
        pluginPlaceholders.put("playerName", playerName);
        pluginPlaceholders.put("backButton", (this.serverInfo.getServer().isProxy() ? Html.BACK_BUTTON_NETWORK : Html.BACK_BUTTON_SERVER).create());
        pluginPlaceholders.put("navPluginsTabs", pluginTabs.getNav());
        pluginPlaceholders.put("pluginsTabs", pluginTabs.getTab());
        return UnaryChain.of(this.templateHtml).chain(this.theme::replaceThemeColors).chain(placeholders::apply).chain(pluginPlaceholders::apply).chain(this.locale::replaceLanguageInHtml).apply();
    }
}

