/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import com.djrapitops.plan.delivery.rendering.html.structure.NavLink;
import com.djrapitops.plan.delivery.rendering.html.structure.TabsElement;
import com.djrapitops.plan.extension.ElementOrder;
import com.djrapitops.plan.extension.FormatType;
import com.djrapitops.plan.extension.implementation.TabInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.results.ExtensionDescriptive;
import com.djrapitops.plan.extension.implementation.results.ExtensionInformation;
import com.djrapitops.plan.extension.implementation.results.ExtensionTabData;
import com.djrapitops.plan.extension.implementation.results.ExtensionTableData;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PlayerPluginTab
implements Comparable<PlayerPluginTab> {
    private String serverName;
    private List<ExtensionData> playerData;
    private Map<FormatType, Formatter<Long>> numberFormatters;
    private Formatter<Double> decimalFormatter;
    private Formatter<Double> percentageFormatter;
    private String nav;
    private String tab;
    private boolean hasWideTable;

    public PlayerPluginTab(String nav, String tab) {
        this.nav = nav;
        this.tab = tab;
    }

    public PlayerPluginTab(String serverName, List<ExtensionData> playerData, Formatters formatters) {
        this.serverName = serverName;
        this.playerData = playerData;
        this.numberFormatters = new EnumMap<FormatType, Formatter<Long>>(FormatType.class);
        this.numberFormatters.put(FormatType.DATE_SECOND, formatters.secondLong());
        this.numberFormatters.put(FormatType.DATE_YEAR, formatters.yearLong());
        this.numberFormatters.put(FormatType.TIME_MILLISECONDS, formatters.timeAmount());
        this.numberFormatters.put(FormatType.NONE, Object::toString);
        this.decimalFormatter = formatters.decimals();
        this.percentageFormatter = formatters.percentage();
        this.hasWideTable = false;
        this.generate();
    }

    public String getNav() {
        return this.nav;
    }

    public String getTab() {
        return this.tab;
    }

    private void generate() {
        if (this.playerData.isEmpty()) {
            this.nav = NavLink.collapsed(Icon.called("cubes").build(), "plugins-" + this.serverName + " (No Data)", this.serverName + " (No Data)").toHtml();
            this.tab = this.wrapInWideTab(this.serverName + " (No Data)", "<div class=\"card\"><div class=\"card-body\"><p>No Extension Data</p></div></div>");
        } else {
            this.nav = NavLink.collapsed(Icon.called("cubes").build(), "plugins-" + this.serverName, this.serverName).toHtml();
            this.tab = this.generatePageTab();
        }
    }

    private String generatePageTab() {
        Collections.sort(this.playerData);
        StringBuilder tabBuilder = new StringBuilder();
        for (ExtensionData datum : this.playerData) {
            String tabsElement;
            ExtensionInformation extensionInformation = datum.getExtensionInformation();
            boolean onlyGeneric = datum.hasOnlyGenericTab();
            if (onlyGeneric) {
                ExtensionTabData genericTabData = datum.getTabs().get(0);
                tabsElement = this.buildContentHtml(genericTabData);
            } else {
                tabsElement = new TabsElement((TabsElement.Tab[])datum.getTabs().stream().map(this::wrapToTabElementTab).toArray(TabsElement.Tab[]::new)).toHtmlFull();
            }
            tabBuilder.append(this.wrapInContainer(extensionInformation, tabsElement));
        }
        return this.wrapInCardColumnsTab(this.serverName, tabBuilder.toString());
    }

    private String wrapInWideTab(String serverName, String content) {
        return "<div class=\"tab\" id=\"" + NavLink.format("plugins-" + serverName) + "\"><div class=\"container-fluid mt-4\"><div class=\"d-sm-flex align-items-center justify-content-between mb-4\"><h1 class=\"h3 mb-0 text-gray-800\"><i class=\"sidebar-toggler fa fa-fw fa-bars\"></i>" + serverName + " &middot; Plugins Overview</h1>${backButton}</div><div class=\"row\"><div class=\"col-md-12\">" + content + "</div></div></div></div>";
    }

    private String wrapInCardColumnsTab(String serverName, String content) {
        return "<div class=\"tab\" id=\"" + NavLink.format("plugins-" + serverName) + "\"><div class=\"container-fluid mt-4\"><div class=\"d-sm-flex align-items-center justify-content-between mb-4\"><h1 class=\"h3 mb-0 text-gray-800\"><i class=\"sidebar-toggler fa fa-fw fa-bars\"></i>" + serverName + " &middot; Plugins Overview</h1>${backButton}</div><div class=\"card-columns\">" + content + "</div></div></div>";
    }

    private TabsElement.Tab wrapToTabElementTab(ExtensionTabData tabData) {
        TabInformation tabInformation = tabData.getTabInformation();
        String tabContentHtml = this.buildContentHtml(tabData);
        String tabName = tabInformation.getTabName();
        return new TabsElement.Tab(tabName.isEmpty() ? Icon.called("info-circle").build().toHtml() + " General" : Icon.fromExtensionIcon(tabInformation.getTabIcon()).toHtml() + ' ' + tabName, tabContentHtml);
    }

    private String buildContentHtml(ExtensionTabData tabData) {
        TabInformation tabInformation = tabData.getTabInformation();
        ElementOrder[] order = tabInformation.getTabElementOrder().orElse(ElementOrder.values());
        String values = this.buildValuesHtml(tabData);
        String valuesHtml = values.isEmpty() ? "" : "<div class=\"card-body\">" + values + "</div>";
        String tablesHtml = this.buildTablesHtml(tabData);
        StringBuilder builder = new StringBuilder();
        block4: for (ElementOrder ordering : order) {
            switch (ordering) {
                case VALUES: {
                    builder.append(valuesHtml);
                    continue block4;
                }
                case TABLE: {
                    builder.append(tablesHtml);
                    continue block4;
                }
            }
        }
        return builder.toString();
    }

    private String buildTablesHtml(ExtensionTabData tabData) {
        StringBuilder builder = new StringBuilder();
        for (ExtensionTableData tableData : tabData.getTableData()) {
            if (tableData.isWideTable()) {
                this.hasWideTable = true;
            }
            builder.append(tableData.getHtmlTable().buildHtml());
        }
        return builder.toString();
    }

    private String buildValuesHtml(ExtensionTabData tabData) {
        StringBuilder builder = new StringBuilder();
        for (String key : tabData.getValueOrder()) {
            tabData.getBoolean(key).ifPresent(data -> this.append(builder, data.getDescriptive(), data.getFormattedValue()));
            tabData.getDouble(key).ifPresent(data -> this.append(builder, data.getDescriptive(), data.getFormattedValue(this.decimalFormatter)));
            tabData.getPercentage(key).ifPresent(data -> this.append(builder, data.getDescriptive(), data.getFormattedValue(this.percentageFormatter)));
            tabData.getNumber(key).ifPresent(data -> this.append(builder, data.getDescriptive(), data.getFormattedValue(this.numberFormatters.get((Object)data.getFormatType()))));
            tabData.getString(key).ifPresent(data -> this.append(builder, data.getDescriptive(), data.getFormattedValue()));
        }
        return builder.toString();
    }

    private void append(StringBuilder builder, ExtensionDescriptive descriptive, String formattedValue) {
        Optional<String> description = descriptive.getDescription();
        if (description.isPresent()) {
            builder.append("<p title=\"").append(description.get()).append("\">");
        } else {
            builder.append("<p>");
        }
        builder.append(Icon.fromExtensionIcon(descriptive.getIcon())).append(' ').append(descriptive.getText()).append("<span class=\"float-right\"><b>").append(formattedValue).append("</b></span></p>");
    }

    private String wrapInContainer(ExtensionInformation information, String tabsElement) {
        String colWidth = this.hasWideTable ? "col-md-8 col-lg-8" : "col-md-4 col-lg-4";
        return "<div class=\"card shadow mb-4\"><div class=\"card-header py-3\"><h6 class=\"m-0 font-weight-bold col-black\">" + Icon.fromExtensionIcon(information.getIcon()) + ' ' + information.getPluginName() + "</h6></div>" + tabsElement + "</div>";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerPluginTab)) {
            return false;
        }
        PlayerPluginTab that = (PlayerPluginTab)o;
        return Objects.equals(this.serverName, that.serverName) && Objects.equals(this.nav, that.nav);
    }

    public int hashCode() {
        return Objects.hash(this.serverName, this.nav);
    }

    @Override
    public int compareTo(PlayerPluginTab other) {
        return String.CASE_INSENSITIVE_ORDER.compare(this.serverName, other.serverName);
    }
}

