/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.formatting.PlaceholderReplacer;
import com.djrapitops.plan.delivery.rendering.html.Contributors;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.config.paths.ProxySettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.version.VersionChecker;

public class PlayersPage
implements Page {
    private final String templateHtml;
    private final VersionChecker versionChecker;
    private final PlanConfig config;
    private final Locale locale;
    private final Theme theme;
    private final ServerInfo serverInfo;

    PlayersPage(String templateHtml, VersionChecker versionChecker, PlanConfig config, Locale locale, Theme theme, ServerInfo serverInfo) {
        this.templateHtml = templateHtml;
        this.versionChecker = versionChecker;
        this.config = config;
        this.locale = locale;
        this.theme = theme;
        this.serverInfo = serverInfo;
    }

    @Override
    public String toHtml() {
        PlaceholderReplacer placeholders = new PlaceholderReplacer();
        placeholders.put("version", this.versionChecker.getUpdateButton().orElse(this.versionChecker.getCurrentVersionButton()));
        placeholders.put("updateModal", this.versionChecker.getUpdateModal());
        placeholders.put("contributors", Contributors.generateContributorHtml());
        if (this.serverInfo.getServer().isProxy()) {
            placeholders.put("networkName", this.config.get(ProxySettings.NETWORK_NAME));
        } else {
            placeholders.put("networkName", this.config.get(PluginSettings.SERVER_NAME));
        }
        return this.locale.replaceLanguageInHtml(placeholders.apply(this.theme.replaceThemeColors(this.templateHtml)));
    }
}

