/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.rendering.pages;

import com.djrapitops.plan.delivery.domain.container.CachingSupplier;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.delivery.formatting.PlaceholderReplacer;
import com.djrapitops.plan.delivery.rendering.html.Contributors;
import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.delivery.rendering.pages.ServerPluginTabs;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.extension.implementation.results.ExtensionData;
import com.djrapitops.plan.extension.implementation.storage.queries.ExtensionServerDataQuery;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.settings.theme.ThemeVal;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.utilities.java.UnaryChain;
import com.djrapitops.plan.version.VersionChecker;
import java.util.List;
import java.util.UUID;

public class ServerPage
implements Page {
    private final String templateHtml;
    private final Server server;
    private final PlanConfig config;
    private final Theme theme;
    private final Locale locale;
    private final VersionChecker versionChecker;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Formatters formatters;

    ServerPage(String templateHtml, Server server, PlanConfig config, Theme theme, Locale locale, VersionChecker versionChecker, DBSystem dbSystem, ServerInfo serverInfo, Formatters formatters) {
        this.templateHtml = templateHtml;
        this.server = server;
        this.config = config;
        this.theme = theme;
        this.locale = locale;
        this.versionChecker = versionChecker;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.formatters = formatters;
    }

    @Override
    public String toHtml() {
        PlaceholderReplacer placeholders = new PlaceholderReplacer();
        UUID serverUUID = this.server.getUuid();
        placeholders.put("serverUUID", serverUUID.toString());
        placeholders.put("serverName", this.server.getIdentifiableName());
        placeholders.put("serverDisplayName", this.server.getName());
        placeholders.put("timeZone", this.config.getTimeZoneOffsetHours());
        placeholders.put("gmPieColors", this.theme.getValue(ThemeVal.GRAPH_GM_PIE));
        placeholders.put("contributors", Contributors.generateContributorHtml());
        placeholders.put("version", this.versionChecker.getUpdateButton().orElse(this.versionChecker.getCurrentVersionButton()));
        placeholders.put("updateModal", this.versionChecker.getUpdateModal());
        CachingSupplier<ServerPluginTabs> pluginTabs = new CachingSupplier<ServerPluginTabs>(() -> {
            List<ExtensionData> extensionData = this.dbSystem.getDatabase().query(new ExtensionServerDataQuery(serverUUID));
            return new ServerPluginTabs(extensionData, this.formatters);
        });
        String nav = JSONCache.getOrCacheString(DataID.EXTENSION_NAV, serverUUID, () -> ((ServerPluginTabs)pluginTabs.get()).getNav());
        String tabs = JSONCache.getOrCacheString(DataID.EXTENSION_TABS, serverUUID, () -> ((ServerPluginTabs)pluginTabs.get()).getTabs());
        PlaceholderReplacer pluginPlaceholders = new PlaceholderReplacer();
        pluginPlaceholders.put("serverUUID", serverUUID.toString());
        pluginPlaceholders.put("serverName", this.server.getIdentifiableName());
        pluginPlaceholders.put("serverDisplayName", this.server.getName());
        pluginPlaceholders.put("backButton", this.serverInfo.getServer().isProxy() ? Html.BACK_BUTTON_NETWORK.create() : "");
        pluginPlaceholders.put("navPluginsTabs", nav);
        pluginPlaceholders.put("tabsPlugins", tabs);
        return UnaryChain.of(this.templateHtml).chain(this.theme::replaceThemeColors).chain(placeholders::apply).chain(pluginPlaceholders::apply).chain(this.locale::replaceLanguageInHtml).apply();
    }
}

