/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.web;

import com.djrapitops.plan.delivery.web.ResolverService;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ResolverSvc
implements ResolverService {
    private final List<Container> basicResolvers = new ArrayList<Container>();
    private final List<Container> regexResolvers = new ArrayList<Container>();

    @Inject
    public ResolverSvc() {
    }

    public void register() {
        ResolverService.Holder.set(this);
    }

    @Override
    public void registerResolver(String pluginName, String start, Resolver resolver) {
        this.basicResolvers.add(new Container(pluginName, checking -> checking.startsWith(start), resolver, start));
        Collections.sort(this.basicResolvers);
    }

    @Override
    public void registerResolverForMatches(String pluginName, Pattern pattern, Resolver resolver) {
        this.regexResolvers.add(new Container(pluginName, pattern.asPredicate(), resolver, pattern.pattern()));
        Collections.sort(this.regexResolvers);
    }

    @Override
    public Optional<Resolver> getResolver(String target) {
        for (Container container : this.basicResolvers) {
            if (!container.matcher.test(target)) continue;
            return Optional.of(container.resolver);
        }
        for (Container container : this.regexResolvers) {
            if (!container.matcher.test(target)) continue;
            return Optional.of(container.resolver);
        }
        return Optional.empty();
    }

    @Override
    public List<Resolver> getResolvers(String target) {
        ArrayList<Resolver> resolvers = new ArrayList<Resolver>();
        for (Container container : this.basicResolvers) {
            if (!container.matcher.test(target)) continue;
            resolvers.add(container.resolver);
        }
        for (Container container : this.regexResolvers) {
            if (!container.matcher.test(target)) continue;
            resolvers.add(container.resolver);
        }
        return resolvers;
    }

    public Optional<String> getPluginInChargeOf(String target) {
        for (Container container : this.basicResolvers) {
            if (!container.matcher.test(target)) continue;
            return Optional.of(container.plugin);
        }
        for (Container container : this.regexResolvers) {
            if (!container.matcher.test(target)) continue;
            return Optional.of(container.plugin);
        }
        return Optional.empty();
    }

    private static class Container
    implements Comparable<Container> {
        final String plugin;
        final Predicate<String> matcher;
        final Resolver resolver;
        final String sortBy;

        public Container(String plugin, Predicate<String> matcher, Resolver resolver, String sortBy) {
            this.plugin = plugin;
            this.matcher = matcher;
            this.resolver = resolver;
            this.sortBy = sortBy;
        }

        @Override
        public int compareTo(Container o) {
            return Integer.compare(o.sortBy.length(), this.sortBy.length());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Container)) {
                return false;
            }
            Container container = (Container)o;
            return Objects.equals(this.plugin, container.plugin) && Objects.equals(this.matcher, container.matcher) && Objects.equals(this.resolver, container.resolver) && Objects.equals(this.sortBy, container.sortBy);
        }

        public int hashCode() {
            return Objects.hash(this.plugin, this.matcher, this.resolver, this.sortBy);
        }
    }
}

