/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.web;

import com.djrapitops.plan.delivery.web.ResourceService;
import com.djrapitops.plan.delivery.web.resource.WebResource;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.ResourceSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.storage.file.Resource;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;
import plan.org.apache.commons.text.TextStringBuilder;

@Singleton
public class ResourceSvc
implements ResourceService {
    public final Set<Snippet> snippets;
    private final PlanFiles files;
    private final ResourceSettings resourceSettings;
    private final Locale locale;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;

    @Inject
    public ResourceSvc(PlanFiles files, PlanConfig config, Locale locale, PluginLogger logger, ErrorLogger errorLogger) {
        this.files = files;
        this.resourceSettings = config.getResourceSettings();
        this.locale = locale;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.snippets = new HashSet<Snippet>();
    }

    public void register() {
        ResourceService.Holder.set(this);
    }

    @Override
    public WebResource getResource(String pluginName, String fileName, Supplier<WebResource> source) {
        this.checkParams(pluginName, fileName, source);
        return this.applySnippets(pluginName, fileName, this.getTheResource(pluginName, fileName, source));
    }

    public void checkParams(String pluginName, String fileName, Supplier<WebResource> source) {
        if (pluginName == null || pluginName.isEmpty()) {
            throw new IllegalArgumentException("'pluginName' can't be '" + pluginName + "'!");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("'fileName' can't be '" + fileName + "'!");
        }
        if (source == null) {
            throw new IllegalArgumentException("'source' can't be null!");
        }
    }

    private WebResource applySnippets(String pluginName, String fileName, WebResource resource) {
        Map<ResourceService.Position, StringBuilder> byPosition = this.calculateSnippets(fileName);
        if (byPosition.isEmpty()) {
            return resource;
        }
        String html = this.applySnippets(resource, byPosition);
        return WebResource.create(html);
    }

    private String applySnippets(WebResource resource, Map<ResourceService.Position, StringBuilder> byPosition) {
        StringBuilder toBodyEnd;
        StringBuilder toBody;
        String html = resource.asString();
        if (html == null) {
            return "Error: Given resource did not support WebResource#asString method properly and returned 'null'";
        }
        StringBuilder toHead = byPosition.get((Object)ResourceService.Position.PRE_CONTENT);
        if (toHead != null) {
            html = StringUtils.replaceOnce(html, "</head>", toHead.append("</head>").toString());
        }
        if ((toBody = byPosition.get((Object)ResourceService.Position.PRE_MAIN_SCRIPT)) != null) {
            html = StringUtils.contains((CharSequence)html, "<script id=\"mainScript\"") ? StringUtils.replaceOnce(html, "<script id=\"mainScript\"", toBody.append("<script id=\"mainScript\"").toString()) : StringUtils.replaceOnce(html, "</body>", toBody.append("</body>").toString());
        }
        if ((toBodyEnd = byPosition.get((Object)ResourceService.Position.AFTER_MAIN_SCRIPT)) != null) {
            html = StringUtils.replaceOnce(html, "</body>", toBodyEnd.append("</body>").toString());
        }
        return html;
    }

    private Map<ResourceService.Position, StringBuilder> calculateSnippets(String fileName) {
        EnumMap<ResourceService.Position, StringBuilder> byPosition = new EnumMap<ResourceService.Position, StringBuilder>(ResourceService.Position.class);
        for (Snippet snippet : this.snippets) {
            if (!snippet.matches(fileName)) continue;
            byPosition.computeIfAbsent(snippet.position, k -> new StringBuilder()).append(snippet.content);
        }
        return byPosition;
    }

    public WebResource getTheResource(String pluginName, String fileName, Supplier<WebResource> source) {
        try {
            if (this.resourceSettings.shouldBeCustomized(pluginName, fileName)) {
                return this.getOrWriteCustomized(fileName, source);
            }
        }
        catch (IOException e) {
            this.errorLogger.log(L.WARN, e, ErrorContext.builder().whatToDo("Report this or provide " + fileName + " in " + this.files.getCustomizationDirectory()).related("Fetching resource", "Of: " + pluginName, fileName).build());
        }
        return source.get();
    }

    public WebResource getOrWriteCustomized(String fileName, Supplier<WebResource> source) throws IOException {
        Optional<Resource> customizedResource = this.files.getCustomizableResource(fileName);
        if (customizedResource.isPresent()) {
            return this.readCustomized(customizedResource.get());
        }
        return this.writeCustomized(fileName, source);
    }

    public WebResource readCustomized(Resource customizedResource) throws IOException {
        try {
            return customizedResource.asWebResource();
        }
        catch (UncheckedIOException readFail) {
            throw readFail.getCause();
        }
    }

    public WebResource writeCustomized(String fileName, Supplier<WebResource> source) throws IOException {
        WebResource original = source.get();
        byte[] bytes = original.asBytes();
        OpenOption[] overwrite = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
        Path to = this.files.getCustomizationDirectory().resolve(fileName);
        Files.createDirectories(to.getParent(), new FileAttribute[0]);
        Files.write(to, bytes, overwrite);
        return original;
    }

    @Override
    public void addScriptsToResource(String pluginName, String fileName, ResourceService.Position position, String ... jsSrcs) {
        this.checkParams(pluginName, fileName, position, jsSrcs);
        String snippet = new TextStringBuilder("<script src=\"").appendWithSeparators(jsSrcs, "\"></script><script src=\"").append("\"></script>").build();
        this.snippets.add(new Snippet(pluginName, fileName, position, snippet));
        if (!"Plan".equals(pluginName)) {
            this.logger.info(this.locale.getString(PluginLang.API_ADD_RESOURCE_JS, new Serializable[]{pluginName, fileName, position.cleanName()}));
        }
    }

    public void checkParams(String pluginName, String fileName, ResourceService.Position position, String[] jsSrcs) {
        if (pluginName == null || pluginName.isEmpty()) {
            throw new IllegalArgumentException("'pluginName' can't be '" + pluginName + "'!");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("'fileName' can't be '" + fileName + "'!");
        }
        if (!fileName.endsWith(".html")) {
            throw new IllegalArgumentException("'" + fileName + "' is not a .html file! Only html files can be added to.");
        }
        if (position == null) {
            throw new IllegalArgumentException("'position' can't be null!");
        }
        if (jsSrcs == null || jsSrcs.length == 0) {
            throw new IllegalArgumentException("Can't add snippets to resource without snippets!");
        }
    }

    @Override
    public void addStylesToResource(String pluginName, String fileName, ResourceService.Position position, String ... cssSrcs) {
        this.checkParams(pluginName, fileName, position, cssSrcs);
        String snippet = new TextStringBuilder("<link href=\"").appendWithSeparators(cssSrcs, "\" rel=\"stylesheet\"></link><link href=\"").append("\" rel=\"stylesheet\">").build();
        this.snippets.add(new Snippet(pluginName, fileName, position, snippet));
        if (!"Plan".equals(pluginName)) {
            this.logger.info(this.locale.getString(PluginLang.API_ADD_RESOURCE_CSS, new Serializable[]{pluginName, fileName, position.cleanName()}));
        }
    }

    private static class Snippet {
        private final String pluginName;
        private final String fileName;
        private final ResourceService.Position position;
        private final String content;

        public Snippet(String pluginName, String fileName, ResourceService.Position position, String content) {
            this.pluginName = pluginName;
            this.fileName = fileName;
            this.position = position;
            this.content = content;
        }

        public boolean matches(String fileName) {
            return fileName.equals(this.fileName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Snippet snippet = (Snippet)o;
            return Objects.equals(this.pluginName, snippet.pluginName) && Objects.equals(this.fileName, snippet.fileName) && this.position == snippet.position && Objects.equals(this.content, snippet.content);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.pluginName, this.fileName, this.position, this.content});
        }
    }
}

