/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.web.resolver;

import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.URIPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public final class CompositeResolver
implements Resolver {
    private final List<String> prefixes = new ArrayList<String>();
    private final List<Function<Request, Optional<Response>>> resolvers = new ArrayList<Function<Request, Optional<Response>>>();
    private final List<Predicate<Request>> canAccess = new ArrayList<Predicate<Request>>();

    CompositeResolver() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private Optional<Function<Request, Optional<Response>>> getResolver(URIPath target) {
        return target.getPart(0).flatMap(this::findResolver);
    }

    private Optional<Predicate<Request>> getAccessCheck(URIPath target) {
        return target.getPart(0).flatMap(this::findAccessCheck);
    }

    private Optional<Function<Request, Optional<Response>>> findResolver(String prefix) {
        for (int i = 0; i < this.prefixes.size(); ++i) {
            if (!this.prefixes.get(i).equals(prefix)) continue;
            return Optional.of(this.resolvers.get(i));
        }
        return Optional.empty();
    }

    private Optional<Predicate<Request>> findAccessCheck(String prefix) {
        for (int i = 0; i < this.prefixes.size(); ++i) {
            if (!this.prefixes.get(i).equals(prefix)) continue;
            return Optional.of(this.canAccess.get(i));
        }
        return Optional.empty();
    }

    void add(String prefix, Resolver resolver) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix can not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Resolver can not be null");
        }
        this.prefixes.add(prefix);
        this.resolvers.add(resolver::resolve);
        this.canAccess.add(resolver::canAccess);
    }

    void add(String prefix, Function<Request, Response> resolver, Predicate<Request> accessCheck) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix can not be null");
        }
        if (resolver == null) {
            throw new IllegalArgumentException("Function<Request, Response> resolver can not be null");
        }
        if (accessCheck == null) {
            throw new IllegalArgumentException("Predicate<Request> accessCheck can not be null");
        }
        this.prefixes.add(prefix);
        this.resolvers.add(request -> Optional.ofNullable(resolver.apply((Request)request)));
        this.canAccess.add(accessCheck);
    }

    @Override
    public boolean canAccess(Request request) {
        Request forThis = request.omitFirstInPath();
        return this.getAccessCheck(forThis.getPath()).map(resolver -> resolver.test(forThis)).orElse(true);
    }

    @Override
    public Optional<Response> resolve(Request request) {
        Request forThis = request.omitFirstInPath();
        return this.getResolver(forThis.getPath()).flatMap(resolver -> (Optional)resolver.apply(forThis));
    }

    public static class Builder {
        private final CompositeResolver composite = new CompositeResolver();

        private Builder() {
        }

        public Builder add(String prefix, Resolver resolver) {
            this.composite.add(prefix, resolver);
            return this;
        }

        public Builder add(String prefix, Function<Request, Response> resolver, Predicate<Request> accessCheck) {
            this.composite.add(prefix, resolver, accessCheck);
            return this;
        }

        public CompositeResolver build() {
            return this.composite;
        }
    }
}

