/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.web.resolver;

import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resource.WebResource;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import plan.com.google.gson.Gson;

public class ResponseBuilder {
    private final Response response = new Response();

    ResponseBuilder() {
    }

    public ResponseBuilder setMimeType(String mimeType) {
        return this.setHeader("Content-Type", mimeType);
    }

    public ResponseBuilder setStatus(int code) {
        this.response.code = code;
        return this;
    }

    public ResponseBuilder setHeader(String header, Object value) {
        this.response.headers.put(header, value.toString());
        return this;
    }

    public ResponseBuilder redirectTo(String url) {
        return this.setStatus(302).setHeader("Location", url).setContent(new byte[0]);
    }

    public ResponseBuilder setContent(WebResource resource) {
        return this.setContent(resource.asBytes());
    }

    public ResponseBuilder setContent(byte[] bytes) {
        this.response.bytes = bytes;
        return this.setHeader("Content-Length", bytes.length).setHeader("Accept-Ranges", "bytes");
    }

    public ResponseBuilder setContent(String utf8String) {
        return this.setContent(utf8String, StandardCharsets.UTF_8);
    }

    public ResponseBuilder setContent(String content, Charset charset) {
        String[] parts;
        if (content == null) {
            return this.setContent(new byte[0]);
        }
        if (charset == null) {
            return this.setContent(content);
        }
        String mimeType = this.getMimeType();
        this.response.charset = charset;
        if (mimeType != null && (parts = mimeType.split(";")).length == 1) {
            this.setMimeType(parts[0] + "; charset=" + charset.name().toLowerCase());
        }
        return this.setContent(content.getBytes(charset));
    }

    public ResponseBuilder setJSONContent(Object objectToSerialize) {
        if (objectToSerialize instanceof String) {
            return this.setJSONContent((String)objectToSerialize);
        }
        return this.setJSONContent(new Gson().toJson(objectToSerialize));
    }

    public ResponseBuilder setJSONContent(String json) {
        return this.setMimeType("application/json").setContent(json);
    }

    public Response build() {
        byte[] content = this.response.bytes;
        this.exceptionIf(content == null, "Content not defined for Response");
        String mimeType = this.getMimeType();
        this.exceptionIf(content.length > 0 && mimeType == null, "MIME Type not defined for Response");
        this.exceptionIf(content.length > 0 && mimeType.isEmpty(), "MIME Type empty for Response");
        this.exceptionIf(this.response.code < 100 || this.response.code >= 600, "HTTP Status code out of bounds (" + this.response.code + ")");
        return this.response;
    }

    private String getMimeType() {
        return this.response.headers.get("Content-Type");
    }

    private void exceptionIf(boolean value, String errorMsg) {
        if (value) {
            throw new InvalidResponseException(errorMsg);
        }
    }

    public static class InvalidResponseException
    extends IllegalStateException {
        public InvalidResponseException(String s) {
            super(s);
        }
    }
}

