/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.web.resolver.request;

import com.djrapitops.plan.delivery.web.resolver.request.URIPath;
import com.djrapitops.plan.delivery.web.resolver.request.URIQuery;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import java.util.Map;
import java.util.Optional;
import plan.org.apache.commons.lang3.StringUtils;

public final class Request {
    private final String method;
    private final URIPath path;
    private final URIQuery query;
    private final WebUser user;
    private final Map<String, String> headers;

    public Request(String method, URIPath path, URIQuery query, WebUser user, Map<String, String> headers) {
        this.method = method;
        this.path = path;
        this.query = query;
        this.user = user;
        this.headers = headers;
    }

    public Request(String method, String target, WebUser user, Map<String, String> headers) {
        this.method = method;
        if (target.contains("?")) {
            String[] halves = StringUtils.split(target, "?", 2);
            this.path = new URIPath(halves[0]);
            this.query = new URIQuery(halves[1]);
        } else {
            this.path = new URIPath(target);
            this.query = new URIQuery("");
        }
        this.user = user;
        this.headers = headers;
    }

    public String getMethod() {
        return this.method;
    }

    public URIPath getPath() {
        return this.path;
    }

    public URIQuery getQuery() {
        return this.query;
    }

    public Optional<WebUser> getUser() {
        return Optional.ofNullable(this.user);
    }

    public Optional<String> getHeader(String key) {
        return Optional.ofNullable(this.headers.get(key));
    }

    public Request omitFirstInPath() {
        return new Request(this.method, this.path.omitFirst(), this.query, this.user, this.headers);
    }

    public String toString() {
        return "Request{method='" + this.method + '\'' + ", path=" + this.path + ", query=" + this.query + ", user=" + this.user + ", headers=" + this.headers + '}';
    }
}

