/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.web.resolver.request;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import plan.org.apache.commons.lang3.StringUtils;

public final class URIQuery {
    private final Map<String, String> byKey;

    public URIQuery(Map<String, String> byKey) {
        this.byKey = byKey;
    }

    public URIQuery(String fromURI) {
        this.byKey = this.parseParameters(fromURI);
    }

    private Map<String, String> parseParameters(String fromURI) {
        String[] keysAndValues;
        if (fromURI == null || fromURI.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String kv : keysAndValues = StringUtils.split(fromURI, '&')) {
            String[] keyAndValue;
            if (kv.isEmpty() || (keyAndValue = StringUtils.split(kv, "=", 2)).length < 2) continue;
            try {
                parameters.put(URLDecoder.decode(keyAndValue[0], StandardCharsets.UTF_8.name()), URLDecoder.decode(keyAndValue[1], StandardCharsets.UTF_8.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return parameters;
    }

    public Optional<String> get(String key) {
        return Optional.ofNullable(this.byKey.get(key));
    }

    public String asString() {
        StringBuilder builder = new StringBuilder("?");
        int i = 0;
        int max = this.byKey.size();
        for (Map.Entry<String, String> entry : this.byKey.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            builder.append(key).append('=').append(value);
            if (i < max - 1) {
                builder.append('&');
            }
            ++i;
        }
        return builder.toString();
    }

    public String toString() {
        return "URIQuery{byKey=" + this.byKey + '}';
    }
}

