/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.web.resolver.request;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class WebUser {
    private final String playerName;
    private final String username;
    private final Set<String> permissions;

    public WebUser(String playerName) {
        this.playerName = playerName;
        this.username = playerName;
        this.permissions = new HashSet<String>();
    }

    public WebUser(String playerName, String username, Collection<String> permissions) {
        this.playerName = playerName;
        this.username = username;
        this.permissions = new HashSet<String>(permissions);
    }

    @Deprecated
    public WebUser(String playerName, String ... permissions) {
        this(playerName);
        this.permissions.addAll(Arrays.asList(permissions));
    }

    public boolean hasPermission(String permission) {
        return this.permissions.contains(permission);
    }

    public String getName() {
        return this.playerName;
    }

    public String getUsername() {
        return this.username;
    }

    public String toString() {
        return "WebUser{playerName='" + this.playerName + '\'' + ", username='" + this.username + '\'' + ", permissions=" + this.permissions + '}';
    }
}

