/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.web.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public interface WebResource {
    public static WebResource create(byte[] content) {
        return new ByteResource(content);
    }

    public static WebResource create(String utf8String) {
        return new ByteResource(utf8String.getBytes(StandardCharsets.UTF_8));
    }

    /*
     * Loose catch block
     */
    public static WebResource create(InputStream in) throws IOException {
        try {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                int read;
                byte[] bytes = new byte[1024];
                while ((read = in.read(bytes)) != -1) {
                    out.write(bytes, 0, read);
                }
                ByteResource byteResource = new ByteResource(out.toByteArray());
                return byteResource;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            in.close();
        }
    }

    public byte[] asBytes();

    public String asString();

    public InputStream asStream();

    public static final class ByteResource
    implements WebResource {
        private final byte[] content;

        public ByteResource(byte[] content) {
            this.content = content;
        }

        @Override
        public byte[] asBytes() {
            return this.content;
        }

        @Override
        public String asString() {
            return new String(this.content, StandardCharsets.UTF_8);
        }

        @Override
        public InputStream asStream() {
            return new ByteArrayInputStream(this.content);
        }
    }
}

