/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import com.djrapitops.plan.delivery.webserver.WebServer;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.properties.ServerProperties;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.WebserverSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import java.util.Optional;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class Addresses {
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final Lazy<ServerProperties> serverProperties;
    private final Lazy<WebServer> webserver;

    @Inject
    public Addresses(PlanConfig config, DBSystem dbSystem, Lazy<ServerProperties> serverProperties, Lazy<WebServer> webserver) {
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverProperties = serverProperties;
        this.webserver = webserver;
    }

    public Optional<String> getMainAddress() {
        Optional<String> proxyServerAddress = this.getProxyServerAddress();
        return proxyServerAddress.isPresent() ? proxyServerAddress : this.getAccessAddress();
    }

    public Optional<String> getAccessAddress() {
        WebServer webServer = this.webserver.get();
        if (!webServer.isEnabled()) {
            return Optional.of(this.getFallbackExternalAddress());
        }
        return this.getIP().map(ip -> webServer.getProtocol() + "://" + ip);
    }

    private Optional<String> getIP() {
        int port = this.webserver.get().getPort();
        return this.config.isTrue(WebserverSettings.SHOW_ALTERNATIVE_IP) ? Optional.of(this.config.get(WebserverSettings.ALTERNATIVE_IP).replace("%port%", String.valueOf(port))) : this.getServerPropertyIP().map(ip -> ip + ":" + port);
    }

    private String getFallbackExternalAddress() {
        return this.config.get(WebserverSettings.EXTERNAL_LINK);
    }

    public String getFallbackLocalhostAddress() {
        WebServer webServer = this.webserver.get();
        return webServer.getProtocol() + "://localhost:" + webServer.getPort();
    }

    public Optional<String> getProxyServerAddress() {
        return this.dbSystem.getDatabase().query(ServerQueries.fetchProxyServerInformation()).map(Server::getWebAddress).filter(this::isValidAddress);
    }

    private boolean isValidAddress(String address) {
        return !address.isEmpty() && !"0.0.0.0".equals(address);
    }

    public Optional<String> getServerPropertyIP() {
        String ip = this.serverProperties.get().getIp();
        return this.isValidAddress(ip) ? Optional.of(ip) : Optional.empty();
    }
}

