/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.delivery.webserver.WebServer;
import com.djrapitops.plan.delivery.webserver.WebServerSystem;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.config.paths.WebserverSettings;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.IOException;

public class NonProxyWebserverDisableChecker
implements Runnable {
    private final PlanConfig config;
    private final Addresses addresses;
    private final WebServerSystem webServerSystem;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;

    public NonProxyWebserverDisableChecker(PlanConfig config, Addresses addresses, WebServerSystem webServerSystem, PluginLogger logger, ErrorLogger errorLogger) {
        this.config = config;
        this.addresses = addresses;
        this.webServerSystem = webServerSystem;
        this.logger = logger;
        this.errorLogger = errorLogger;
    }

    @Override
    public void run() {
        if (this.config.isFalse(PluginSettings.PROXY_COPY_CONFIG)) {
            return;
        }
        this.addresses.getProxyServerAddress().ifPresent(address -> {
            this.logger.info("Proxy server detected in the database - Proxy Webserver address is '" + address + "'.");
            WebServer webServer = this.webServerSystem.getWebServer();
            if (webServer.isEnabled()) {
                this.disableWebserver(webServer);
            }
        });
    }

    private void disableWebserver(WebServer webServer) {
        this.logger.warn("Disabling Webserver on this server - You can override this behavior by setting '" + PluginSettings.PROXY_COPY_CONFIG.getPath() + "' to false.");
        webServer.disable();
        try {
            this.config.set(WebserverSettings.DISABLED, Boolean.valueOf(true));
            this.config.save();
            this.logger.warn("Note: Set '" + WebserverSettings.DISABLED.getPath() + "' to true");
        }
        catch (IOException e) {
            this.errorLogger.log(L.WARN, e, ErrorContext.builder().whatToDo("Set '" + WebserverSettings.DISABLED.getPath() + "' to true manually.").related("Disabling webserver in config setting", WebserverSettings.DISABLED.getPath()).build());
        }
    }
}

