/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import java.util.concurrent.TimeUnit;
import plan.com.github.benmanes.caffeine.cache.Cache;
import plan.com.github.benmanes.caffeine.cache.Caffeine;

public class PassBruteForceGuard {
    private static final int ATTEMPT_LIMIT = 3;
    private final Cache<String, Integer> failedLoginAttempts = Caffeine.newBuilder().expireAfterWrite(90L, TimeUnit.SECONDS).build();

    public boolean shouldPreventRequest(String accessor) {
        Integer attempts = this.failedLoginAttempts.getIfPresent(accessor);
        if (attempts == null) {
            return false;
        }
        return attempts >= 3;
    }

    public void increaseAttemptCountOnFailedLogin(String accessor) {
        this.failedLoginAttempts.cleanUp();
        Integer attempts = this.failedLoginAttempts.getIfPresent(accessor);
        if (attempts == null) {
            attempts = 0;
        }
        if (attempts >= 3) {
            return;
        }
        this.failedLoginAttempts.put(accessor, attempts + 1);
    }

    public void resetAttemptCount(String accessor) {
        this.failedLoginAttempts.cleanUp();
        this.failedLoginAttempts.invalidate(accessor);
    }

    public static class Disabled
    extends PassBruteForceGuard {
        @Override
        public boolean shouldPreventRequest(String accessor) {
            return false;
        }

        @Override
        public void increaseAttemptCountOnFailedLogin(String accessor) {
        }

        @Override
        public void resetAttemptCount(String accessor) {
        }
    }
}

