/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import com.djrapitops.plan.delivery.domain.auth.User;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.URIPath;
import com.djrapitops.plan.delivery.web.resolver.request.URIQuery;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.delivery.webserver.PassBruteForceGuard;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import com.djrapitops.plan.delivery.webserver.ResponseResolver;
import com.djrapitops.plan.delivery.webserver.ResponseSender;
import com.djrapitops.plan.delivery.webserver.auth.Authentication;
import com.djrapitops.plan.delivery.webserver.auth.BasicAuthentication;
import com.djrapitops.plan.delivery.webserver.auth.CookieAuthentication;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.exceptions.WebUserAuthException;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.config.paths.WebserverSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.utilities.Verify;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;
import plan.org.apache.commons.text.TextStringBuilder;

@Singleton
public class RequestHandler
implements HttpHandler {
    private final Locale locale;
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final Addresses addresses;
    private final ResponseResolver responseResolver;
    private final ResponseFactory responseFactory;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private final PassBruteForceGuard bruteForceGuard;
    private List<String> ipWhitelist = null;

    @Inject
    RequestHandler(Locale locale, PlanConfig config, DBSystem dbSystem, Addresses addresses, ResponseResolver responseResolver, ResponseFactory responseFactory, PluginLogger logger, ErrorLogger errorLogger) {
        this.locale = locale;
        this.config = config;
        this.dbSystem = dbSystem;
        this.addresses = addresses;
        this.responseResolver = responseResolver;
        this.responseFactory = responseFactory;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.bruteForceGuard = new PassBruteForceGuard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) {
        try {
            Response response = this.getResponse(exchange);
            response.getHeaders().putIfAbsent("Access-Control-Allow-Origin", this.config.get(WebserverSettings.CORS_ALLOW_ORIGIN));
            response.getHeaders().putIfAbsent("Access-Control-Allow-Methods", "GET, OPTIONS");
            response.getHeaders().putIfAbsent("Access-Control-Allow-Credentials", "true");
            ResponseSender sender = new ResponseSender(this.addresses, exchange, response);
            sender.send();
        }
        catch (Exception e) {
            if (this.config.isTrue(PluginSettings.DEV_MODE)) {
                this.logger.warn("THIS ERROR IS ONLY LOGGED IN DEV MODE:");
                this.errorLogger.log(L.WARN, e, ErrorContext.builder().whatToDo("THIS ERROR IS ONLY LOGGED IN DEV MODE").related(exchange.getRequestMethod(), exchange.getRemoteAddress(), exchange.getRequestHeaders(), exchange.getResponseHeaders(), exchange.getRequestURI()).build());
            }
        }
        finally {
            exchange.close();
        }
    }

    public Response getResponse(HttpExchange exchange) {
        Response response;
        if (this.ipWhitelist == null) {
            this.ipWhitelist = this.config.get(WebserverSettings.IP_WHITELIST) != false ? this.config.get(WebserverSettings.WHITELIST) : Collections.emptyList();
        }
        String accessor = exchange.getRemoteAddress().getAddress().getHostAddress();
        Request request = null;
        try {
            request = this.buildRequest(exchange);
            if (this.bruteForceGuard.shouldPreventRequest(accessor)) {
                response = this.responseFactory.failedLoginAttempts403();
            } else if (!this.ipWhitelist.isEmpty() && !this.ipWhitelist.contains(accessor)) {
                response = this.responseFactory.ipWhitelist403(accessor);
                this.logger.info(this.locale.getString(PluginLang.WEB_SERVER_NOTIFY_IP_WHITELIST_BLOCK, new Serializable[]{accessor, exchange.getRequestURI().toString()}));
            } else {
                response = this.responseResolver.getResponse(request);
            }
        }
        catch (WebUserAuthException thrownByAuthentication) {
            FailReason failReason = thrownByAuthentication.getFailReason();
            if (failReason == FailReason.USER_PASS_MISMATCH) {
                this.bruteForceGuard.increaseAttemptCountOnFailedLogin(accessor);
                response = this.responseFactory.badRequest(failReason.getReason(), "/auth/login");
            }
            String from = exchange.getRequestURI().toASCIIString();
            response = Response.builder().redirectTo(StringUtils.startsWithAny(from, "/auth/", "/login") ? "/login" : "/login?from=." + from).setHeader("Set-Cookie", "auth=expired; Path=/; Max-Age=1").build();
        }
        if (this.bruteForceGuard.shouldPreventRequest(accessor)) {
            response = this.responseFactory.failedLoginAttempts403();
        }
        if (response.getCode() != 401 && response.getCode() != 403 && request != null && request.getUser().isPresent()) {
            this.bruteForceGuard.resetAttemptCount(accessor);
        }
        return response;
    }

    private Request buildRequest(HttpExchange exchange) {
        String requestMethod = exchange.getRequestMethod();
        URIPath path = new URIPath(exchange.getRequestURI().getPath());
        URIQuery query = new URIQuery(exchange.getRequestURI().getRawQuery());
        WebUser user = this.getWebUser(exchange);
        Map<String, String> headers = this.getRequestHeaders(exchange);
        return new Request(requestMethod, path, query, user, headers);
    }

    private WebUser getWebUser(HttpExchange exchange) {
        return this.getAuthentication(exchange.getRequestHeaders()).map(Authentication::getUser).map(User::toWebUser).orElse(null);
    }

    private Map<String, String> getRequestHeaders(HttpExchange exchange) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> e : exchange.getResponseHeaders().entrySet()) {
            List<String> value = e.getValue();
            headers.put(e.getKey(), new TextStringBuilder().appendWithSeparators(value, ";").build());
        }
        return headers;
    }

    private Optional<Authentication> getAuthentication(Headers requestHeaders) {
        Object authorization;
        if (this.config.isTrue(WebserverSettings.DISABLED_AUTHENTICATION)) {
            return Optional.empty();
        }
        Object cookies = requestHeaders.get("Cookie");
        if (cookies != null && !cookies.isEmpty()) {
            for (String cookie : new TextStringBuilder().appendWithSeparators((Iterable<?>)cookies, ";").build().split(";")) {
                String[] split = cookie.trim().split("=", 2);
                String name = split[0];
                String value = split[1];
                if (!"auth".equals(name)) continue;
                return Optional.of(new CookieAuthentication(value));
            }
        }
        if (Verify.isEmpty(authorization = requestHeaders.get("Authorization"))) {
            return Optional.empty();
        }
        String authLine = (String)authorization.get(0);
        if (StringUtils.contains((CharSequence)authLine, "Basic ")) {
            return Optional.of(new BasicAuthentication(StringUtils.split(authLine, ' ')[1], this.dbSystem.getDatabase()));
        }
        return Optional.empty();
    }

    public ResponseResolver getResponseResolver() {
        return this.responseResolver;
    }
}

