/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.rendering.html.icon.Family;
import com.djrapitops.plan.delivery.rendering.html.icon.Icon;
import com.djrapitops.plan.delivery.rendering.pages.Page;
import com.djrapitops.plan.delivery.rendering.pages.PageFactory;
import com.djrapitops.plan.delivery.web.ResourceService;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.exception.NotFoundException;
import com.djrapitops.plan.delivery.web.resource.WebResource;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.exceptions.WebUserAuthException;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.ErrorPageLang;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.containers.ContainerFetchQueries;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.java.Maps;
import com.djrapitops.plan.utilities.java.UnaryChain;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ResponseFactory {
    private final PlanFiles files;
    private final PageFactory pageFactory;
    private final Locale locale;
    private final DBSystem dbSystem;
    private final Theme theme;

    @Inject
    public ResponseFactory(PlanFiles files, PageFactory pageFactory, Locale locale, DBSystem dbSystem, Theme theme) {
        this.files = files;
        this.pageFactory = pageFactory;
        this.locale = locale;
        this.dbSystem = dbSystem;
        this.theme = theme;
    }

    public WebResource getResource(String resourceName) {
        return ResourceService.getInstance().getResource("Plan", resourceName, () -> this.files.getResourceFromJar("web/" + resourceName).asWebResource());
    }

    public Response debugPageResponse() {
        try {
            return this.forPage(this.pageFactory.debugPage());
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate debug page");
        }
    }

    private Response forPage(Page page) {
        return Response.builder().setMimeType("text/html").setContent(page.toHtml()).build();
    }

    private Response forInternalError(Throwable error, String cause) {
        return Response.builder().setMimeType("text/html").setContent(this.pageFactory.internalErrorPage(cause, error).toHtml()).setStatus(500).build();
    }

    public Response playersPageResponse() {
        try {
            Optional<Response> error = this.checkDbClosedError();
            if (error.isPresent()) {
                return error.get();
            }
            return this.forPage(this.pageFactory.playersPage());
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate players page");
        }
    }

    private Optional<Response> checkDbClosedError() {
        Database.State dbState = this.dbSystem.getDatabase().getState();
        if (dbState != Database.State.OPEN) {
            try {
                return Optional.of(this.buildDBNotOpenResponse(dbState));
            }
            catch (IOException e) {
                return Optional.of(this.forInternalError(e, "Database was not open, additionally failed to generate error page for that"));
            }
        }
        return Optional.empty();
    }

    private Response buildDBNotOpenResponse(Database.State dbState) throws IOException {
        return Response.builder().setMimeType("text/html").setContent(this.pageFactory.errorPage("503 Resources Unavailable", "Database is " + dbState.name() + " - Please try again later. You can check database status with /plan info").toHtml()).setStatus(503).build();
    }

    public Response internalErrorResponse(Throwable e, String s) {
        return this.forInternalError(e, s);
    }

    public Response networkPageResponse() {
        Optional<Response> error = this.checkDbClosedError();
        if (error.isPresent()) {
            return error.get();
        }
        try {
            return this.forPage(this.pageFactory.networkPage());
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate network page");
        }
    }

    public Response serverPageResponse(UUID serverUUID) {
        Optional<Response> error = this.checkDbClosedError();
        if (error.isPresent()) {
            return error.get();
        }
        try {
            return this.forPage(this.pageFactory.serverPage(serverUUID));
        }
        catch (NotFoundException e) {
            return this.notFound404(e.getMessage());
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate server page");
        }
    }

    public Response rawPlayerPageResponse(UUID playerUUID) {
        PlayerContainer player = this.dbSystem.getDatabase().query(ContainerFetchQueries.fetchPlayerContainer(playerUUID));
        return Response.builder().setMimeType("application/json").setJSONContent(player.mapToNormalMap()).build();
    }

    public Response javaScriptResponse(String fileName) {
        try {
            String content = UnaryChain.of(this.getResource(fileName).asString()).chain(this.theme::replaceThemeColors).chain(resource -> {
                if (fileName.startsWith("vendor/") || fileName.startsWith("/vendor/")) {
                    return resource;
                }
                return this.locale.replaceLanguageInJavascript((String)resource);
            }).apply();
            return Response.builder().setMimeType("application/javascript").setContent(content).setStatus(200).build();
        }
        catch (UncheckedIOException e) {
            return this.notFound404("JS File not found from jar: " + fileName + ", " + e.toString());
        }
    }

    public Response cssResponse(String fileName) {
        try {
            String content = this.theme.replaceThemeColors(this.getResource(fileName).asString());
            return Response.builder().setMimeType("text/css").setContent(content).setStatus(200).build();
        }
        catch (UncheckedIOException e) {
            return this.notFound404("CSS File not found from jar: " + fileName + ", " + e.toString());
        }
    }

    public Response imageResponse(String fileName) {
        try {
            return Response.builder().setMimeType("image/gif").setContent(this.getResource(fileName)).setStatus(200).build();
        }
        catch (UncheckedIOException e) {
            return this.notFound404("Image File not found from jar: " + fileName + ", " + e.toString());
        }
    }

    public Response fontResponse(String fileName) {
        String type = fileName.endsWith(".woff") ? "application/font-woff" : (fileName.endsWith(".woff2") ? "application/font-woff2" : (fileName.endsWith(".eot") ? "application/vnd.ms-fontobject" : (fileName.endsWith(".ttf") ? "application/x-font-ttf" : "application/octet-stream")));
        try {
            return Response.builder().setMimeType(type).setContent(this.getResource(fileName)).build();
        }
        catch (UncheckedIOException e) {
            return this.notFound404("Font File not found from jar: " + fileName + ", " + e.toString());
        }
    }

    public Response redirectResponse(String location) {
        return Response.builder().redirectTo(location).build();
    }

    public Response faviconResponse() {
        try {
            return Response.builder().setMimeType("image/x-icon").setContent(this.getResource("favicon.ico")).build();
        }
        catch (UncheckedIOException e) {
            return this.forInternalError(e, "Could not read favicon");
        }
    }

    public Response pageNotFound404() {
        return this.notFound404(this.locale.getString(ErrorPageLang.UNKNOWN_PAGE_404));
    }

    public Response uuidNotFound404() {
        return this.notFound404(this.locale.getString(ErrorPageLang.UUID_404));
    }

    public Response playerNotFound404() {
        return this.notFound404(this.locale.getString(ErrorPageLang.NOT_PLAYED_404));
    }

    public Response notFound404(String message) {
        try {
            return Response.builder().setMimeType("text/html").setContent(this.pageFactory.errorPage(Icon.called("map-signs").build(), "404 " + message, message).toHtml()).setStatus(404).build();
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate 404 page with message '" + message + "'");
        }
    }

    public Response basicAuthFail(WebUserAuthException e) {
        try {
            FailReason failReason = e.getFailReason();
            String reason = failReason.getReason();
            if (failReason == FailReason.ERROR) {
                StringBuilder errorBuilder = new StringBuilder("</p><pre>");
                for (String line : this.getStackTrace(e.getCause())) {
                    errorBuilder.append(line);
                }
                errorBuilder.append("</pre>");
                reason = reason + errorBuilder.toString();
            }
            return Response.builder().setMimeType("text/html").setContent(this.pageFactory.errorPage(Icon.called("lock").build(), "401 Unauthorized", "Authentication Failed.</p><p><b>Reason: " + reason + "</b></p><p>").toHtml()).setStatus(401).setHeader("WWW-Authenticate", "Basic realm=\"" + failReason.getReason() + "\"").build();
        }
        catch (IOException jarReadFailed) {
            return this.forInternalError(e, "Failed to generate PromptAuthorizationResponse");
        }
    }

    private List<String> getStackTrace(Throwable throwable) {
        List<String> causeTrace;
        ArrayList<String> stackTrace = new ArrayList<String>();
        stackTrace.add(throwable.toString());
        for (StackTraceElement element : throwable.getStackTrace()) {
            stackTrace.add("    " + element.toString());
        }
        Throwable cause = throwable.getCause();
        if (cause != null && !(causeTrace = this.getStackTrace(cause)).isEmpty()) {
            causeTrace.set(0, "Caused by: " + causeTrace.get(0));
            stackTrace.addAll(causeTrace);
        }
        return stackTrace;
    }

    public Response forbidden403() {
        return this.forbidden403("Your user is not authorized to view this page.<br>If you believe this is an error contact staff to change your access level.");
    }

    public Response forbidden403(String message) {
        try {
            return Response.builder().setMimeType("text/html").setContent(this.pageFactory.errorPage(Icon.called("hand-paper").of(Family.REGULAR).build(), "403 Forbidden", message).toHtml()).setStatus(403).build();
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate 403 page");
        }
    }

    public Response failedLoginAttempts403() {
        return Response.builder().setMimeType("text/html").setContent("<h1>403 Forbidden</h1><p>You have too many failed login attempts. Please wait 2 minutes until attempting again.</p><script>setTimeout(() => location.reload(), 120500);\" +\n</script>").setStatus(403).build();
    }

    public Response ipWhitelist403(String accessor) {
        return Response.builder().setMimeType("text/html").setContent("<h1>403 Forbidden</h1><p>IP-whitelist enabled, \"" + accessor + "\" is not on the list!</p>").setStatus(403).build();
    }

    public Response basicAuth() {
        try {
            String tips = "<br>- Ensure you have registered a user with <b>/plan register</b><br>- Check that the username and password are correct<br>- Username and password are case-sensitive<br><br>If you have forgotten your password, ask a staff member to delete your old user and re-register.";
            return Response.builder().setMimeType("text/html").setContent(this.pageFactory.errorPage(Icon.called("lock").build(), "401 Unauthorized", "Authentication Failed." + tips).toHtml()).setStatus(401).setHeader("WWW-Authenticate", "Basic realm=\"Plan WebUser (/plan register)\"").build();
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate PromptAuthorizationResponse");
        }
    }

    public Response badRequest(String errorMessage, String target) {
        return Response.builder().setMimeType("application/json").setJSONContent(Maps.builder(String.class, Object.class).put("status", 400).put("error", errorMessage).put("requestedTarget", target).build()).setStatus(400).build();
    }

    public Response playerPageResponse(UUID playerUUID) {
        try {
            return this.forPage(this.pageFactory.playerPage(playerUUID));
        }
        catch (IllegalStateException e) {
            return this.playerNotFound404();
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate player page");
        }
    }

    public Response loginPageResponse() {
        try {
            return this.forPage(this.pageFactory.loginPage());
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate player page");
        }
    }

    public Response registerPageResponse() {
        try {
            return this.forPage(this.pageFactory.registerPage());
        }
        catch (IOException e) {
            return this.forInternalError(e, "Failed to generate player page");
        }
    }
}

