/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import com.djrapitops.plan.delivery.web.ResolverService;
import com.djrapitops.plan.delivery.web.ResolverSvc;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.exception.BadRequestException;
import com.djrapitops.plan.delivery.web.resolver.exception.NotFoundException;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import com.djrapitops.plan.delivery.webserver.WebServer;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.delivery.webserver.resolver.DebugPageResolver;
import com.djrapitops.plan.delivery.webserver.resolver.PlayerPageResolver;
import com.djrapitops.plan.delivery.webserver.resolver.PlayersPageResolver;
import com.djrapitops.plan.delivery.webserver.resolver.RootPageResolver;
import com.djrapitops.plan.delivery.webserver.resolver.ServerPageResolver;
import com.djrapitops.plan.delivery.webserver.resolver.StaticResourceResolver;
import com.djrapitops.plan.delivery.webserver.resolver.auth.LoginPageResolver;
import com.djrapitops.plan.delivery.webserver.resolver.auth.LoginResolver;
import com.djrapitops.plan.delivery.webserver.resolver.auth.LogoutResolver;
import com.djrapitops.plan.delivery.webserver.resolver.auth.RegisterPageResolver;
import com.djrapitops.plan.delivery.webserver.resolver.auth.RegisterResolver;
import com.djrapitops.plan.delivery.webserver.resolver.json.RootJSONResolver;
import com.djrapitops.plan.exceptions.WebUserAuthException;
import com.djrapitops.plan.exceptions.connection.ForbiddenException;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ResponseResolver {
    private final DebugPageResolver debugPageResolver;
    private final PlayersPageResolver playersPageResolver;
    private final PlayerPageResolver playerPageResolver;
    private final ServerPageResolver serverPageResolver;
    private final RootPageResolver rootPageResolver;
    private final RootJSONResolver rootJSONResolver;
    private final StaticResourceResolver staticResourceResolver;
    private final LoginPageResolver loginPageResolver;
    private final RegisterPageResolver registerPageResolver;
    private final LoginResolver loginResolver;
    private final LogoutResolver logoutResolver;
    private final RegisterResolver registerResolver;
    private final ErrorLogger errorLogger;
    private final ResolverService resolverService;
    private final ResponseFactory responseFactory;
    private final Lazy<WebServer> webServer;

    @Inject
    public ResponseResolver(ResolverSvc resolverService, ResponseFactory responseFactory, Lazy<WebServer> webServer, DebugPageResolver debugPageResolver, PlayersPageResolver playersPageResolver, PlayerPageResolver playerPageResolver, ServerPageResolver serverPageResolver, RootPageResolver rootPageResolver, RootJSONResolver rootJSONResolver, StaticResourceResolver staticResourceResolver, LoginPageResolver loginPageResolver, RegisterPageResolver registerPageResolver, LoginResolver loginResolver, LogoutResolver logoutResolver, RegisterResolver registerResolver, ErrorLogger errorLogger) {
        this.resolverService = resolverService;
        this.responseFactory = responseFactory;
        this.webServer = webServer;
        this.debugPageResolver = debugPageResolver;
        this.playersPageResolver = playersPageResolver;
        this.playerPageResolver = playerPageResolver;
        this.serverPageResolver = serverPageResolver;
        this.rootPageResolver = rootPageResolver;
        this.rootJSONResolver = rootJSONResolver;
        this.staticResourceResolver = staticResourceResolver;
        this.loginPageResolver = loginPageResolver;
        this.registerPageResolver = registerPageResolver;
        this.loginResolver = loginResolver;
        this.logoutResolver = logoutResolver;
        this.registerResolver = registerResolver;
        this.errorLogger = errorLogger;
    }

    public void registerPages() {
        String plugin = "Plan";
        this.resolverService.registerResolver(plugin, "/debug", this.debugPageResolver);
        this.resolverService.registerResolver(plugin, "/players", this.playersPageResolver);
        this.resolverService.registerResolver(plugin, "/player", this.playerPageResolver);
        this.resolverService.registerResolver(plugin, "/favicon.ico", request -> Optional.of(this.responseFactory.faviconResponse()));
        this.resolverService.registerResolver(plugin, "/network", this.serverPageResolver);
        this.resolverService.registerResolver(plugin, "/server", this.serverPageResolver);
        this.resolverService.registerResolver(plugin, "/login", this.loginPageResolver);
        this.resolverService.registerResolver(plugin, "/register", this.registerPageResolver);
        this.resolverService.registerResolver(plugin, "/auth/login", this.loginResolver);
        this.resolverService.registerResolver(plugin, "/auth/logout", this.logoutResolver);
        this.resolverService.registerResolver(plugin, "/auth/register", this.registerResolver);
        this.resolverService.registerResolverForMatches(plugin, Pattern.compile("^/$"), this.rootPageResolver);
        this.resolverService.registerResolverForMatches(plugin, Pattern.compile("^.*/(vendor|css|js|img)/.*"), this.staticResourceResolver);
        this.resolverService.registerResolver(plugin, "/v1", this.rootJSONResolver.getResolver());
    }

    public Response getResponse(Request request) {
        try {
            return this.tryToGetResponse(request);
        }
        catch (NotFoundException e) {
            return this.responseFactory.notFound404(e.getMessage());
        }
        catch (ForbiddenException e) {
            return this.responseFactory.forbidden403(e.getMessage());
        }
        catch (BadRequestException e) {
            return this.responseFactory.badRequest(e.getMessage(), request.getPath().asString());
        }
        catch (WebUserAuthException e) {
            throw e;
        }
        catch (Exception e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)request).build());
            return this.responseFactory.internalErrorResponse(e, request.getPath().asString());
        }
    }

    private Response tryToGetResponse(Request request) {
        if ("OPTIONS".equalsIgnoreCase(request.getMethod())) {
            return Response.builder().setStatus(204).setContent(new byte[0]).build();
        }
        Optional<WebUser> user = request.getUser();
        List<Resolver> foundResolvers = this.resolverService.getResolvers(request.getPath().asString());
        if (foundResolvers.isEmpty()) {
            return this.responseFactory.pageNotFound404();
        }
        for (Resolver resolver : foundResolvers) {
            Optional<Response> resolved;
            boolean isAuthRequired;
            boolean bl = isAuthRequired = this.webServer.get().isAuthRequired() && resolver.requiresAuth(request);
            if (isAuthRequired) {
                if (!user.isPresent()) {
                    if (this.webServer.get().isUsingHTTPS()) {
                        throw new WebUserAuthException(FailReason.NO_USER_PRESENT);
                    }
                    return this.responseFactory.forbidden403();
                }
                if (resolver.canAccess(request)) {
                    resolved = resolver.resolve(request);
                    if (!resolved.isPresent()) continue;
                    return resolved.get();
                }
                return this.responseFactory.forbidden403();
            }
            resolved = resolver.resolve(request);
            if (!resolved.isPresent()) continue;
            return resolved.get();
        }
        return this.responseFactory.pageNotFound404();
    }
}

