/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.webserver.Addresses;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class ResponseSender {
    private final Addresses addresses;
    private final HttpExchange exchange;
    private final Response response;

    public ResponseSender(Addresses addresses, HttpExchange exchange, Response response) {
        this.addresses = addresses;
        this.exchange = exchange;
        this.response = response;
    }

    public void send() throws IOException {
        this.setResponseHeaders();
        if ("HEAD".equals(this.exchange.getRequestMethod())) {
            this.sendHeadResponse();
        } else if ("bytes".equalsIgnoreCase(this.response.getHeaders().get("Accept-Ranges"))) {
            this.sendRawBytes();
        } else {
            this.sendCompressed();
        }
    }

    public void sendHeadResponse() throws IOException {
        try {
            this.exchange.getResponseHeaders().remove("Content-Length");
            this.beginSend();
        }
        finally {
            this.exchange.getRequestBody().close();
        }
    }

    private void setResponseHeaders() {
        Headers headers = this.exchange.getResponseHeaders();
        Map<String, String> responseHeaders = this.response.getHeaders();
        this.correctRedirect(responseHeaders);
        for (Map.Entry<String, String> header : responseHeaders.entrySet()) {
            headers.set(header.getKey(), header.getValue());
        }
    }

    private void correctRedirect(Map<String, String> responseHeaders) {
        String redirect = responseHeaders.get("Location");
        if (redirect != null) {
            if (redirect.startsWith("http") || !redirect.startsWith("/")) {
                return;
            }
            this.addresses.getAccessAddress().ifPresent(address -> responseHeaders.put("Location", address + redirect));
        }
    }

    private void sendCompressed() throws IOException {
        this.exchange.getResponseHeaders().set("Content-Encoding", "gzip");
        this.beginSend();
        try (GZIPOutputStream out = new GZIPOutputStream(this.exchange.getResponseBody());){
            this.send(out);
        }
    }

    private void beginSend() throws IOException {
        this.exchange.sendResponseHeaders(this.response.getCode(), 0L);
    }

    private void sendRawBytes() throws IOException {
        this.beginSend();
        try (OutputStream out = this.exchange.getResponseBody();){
            this.send(out);
        }
    }

    private void send(OutputStream out) throws IOException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(this.response.getBytes());){
            int count;
            byte[] buffer = new byte[2048];
            while ((count = bis.read(buffer)) != -1) {
                out.write(buffer, 0, count);
            }
        }
    }
}

