/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.delivery.webserver.RequestHandler;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.config.paths.WebserverSettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.concurrent.BasicThreadFactory;

@Singleton
public class WebServer
implements SubSystem {
    private final Locale locale;
    private final PlanFiles files;
    private final PlanConfig config;
    private final Addresses addresses;
    private final RequestHandler requestHandler;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private int port;
    private boolean enabled = false;
    private HttpServer server;
    private boolean usingHttps = false;

    @Inject
    public WebServer(Locale locale, PlanFiles files, PlanConfig config, Addresses addresses, PluginLogger logger, ErrorLogger errorLogger, RequestHandler requestHandler) {
        this.locale = locale;
        this.files = files;
        this.config = config;
        this.addresses = addresses;
        this.requestHandler = requestHandler;
        this.logger = logger;
        this.errorLogger = errorLogger;
    }

    @Override
    public void enable() {
        this.port = this.config.get(WebserverSettings.PORT);
        this.initServer();
        if (!this.addresses.getAccessAddress().isPresent()) {
            this.logger.warn(this.locale.getString(PluginLang.ENABLE_NOTIFY_BAD_IP));
        }
        if (!this.isEnabled()) {
            if (this.config.isTrue(WebserverSettings.DISABLED)) {
                this.logger.warn(this.locale.getString(PluginLang.ENABLE_NOTIFY_WEB_SERVER_DISABLED));
            } else {
                this.logger.error(this.locale.getString(PluginLang.WEB_SERVER_FAIL_PORT_BIND, Integer.valueOf(this.port)));
            }
        } else if (this.config.get(WebserverSettings.IP_WHITELIST).booleanValue()) {
            this.logger.info(this.locale.getString(PluginLang.WEB_SERVER_NOTIFY_IP_WHITELIST));
        }
        this.requestHandler.getResponseResolver().registerPages();
    }

    private void initServer() {
        if (this.config.isTrue(WebserverSettings.DISABLED)) {
            return;
        }
        if (this.enabled) {
            return;
        }
        try {
            this.usingHttps = this.startHttpsServer();
            this.logger.debug(this.usingHttps ? "Https Start Successful." : "Https Start Failed.");
            if (!this.usingHttps) {
                this.logger.log(L.INFO_COLOR, "\u00a7e" + this.locale.getString(PluginLang.WEB_SERVER_NOTIFY_HTTP_USER_AUTH));
                this.server = HttpServer.create(new InetSocketAddress(this.config.get(WebserverSettings.INTERNAL_IP), this.port), 10);
            } else if (this.server == null) {
                this.logger.log(L.INFO_COLOR, "\u00a7e" + this.locale.getString(PluginLang.WEB_SERVER_NOTIFY_USING_PROXY_MODE));
                this.server = HttpServer.create(new InetSocketAddress(this.config.get(WebserverSettings.INTERNAL_IP), this.port), 10);
            } else if (this.config.isTrue(WebserverSettings.DISABLED_AUTHENTICATION)) {
                this.logger.info(this.locale.getString(PluginLang.WEB_SERVER_NOTIFY_HTTPS_USER_AUTH));
            }
            this.server.createContext("/", this.requestHandler);
            ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 8, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), new BasicThreadFactory.Builder().namingPattern("Plan WebServer Thread-%d").uncaughtExceptionHandler((thread, throwable) -> {
                if (this.config.isTrue(PluginSettings.DEV_MODE)) {
                    this.errorLogger.log(L.WARN, throwable, ErrorContext.builder().whatToDo("THIS ERROR IS ONLY LOGGED IN DEV MODE").build());
                }
            }).build());
            this.server.setExecutor(executor);
            this.server.start();
            this.enabled = true;
            String address = this.addresses.getAccessAddress().orElse(this.addresses.getFallbackLocalhostAddress());
            this.logger.info(this.locale.getString(PluginLang.ENABLED_WEB_SERVER, new Serializable[]{Integer.valueOf(this.server.getAddress().getPort()), address}));
            boolean usingAlternativeIP = this.config.isTrue(WebserverSettings.SHOW_ALTERNATIVE_IP);
            if (!usingAlternativeIP && !this.addresses.getAccessAddress().isPresent()) {
                this.logger.log(L.INFO_COLOR, "\u00a7e" + this.locale.getString(PluginLang.ENABLE_NOTIFY_EMPTY_IP));
            }
        }
        catch (BindException failedToBind) {
            this.logger.error("Webserver failed to bind port: " + failedToBind.toString());
            this.enabled = false;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related("Trying to enable webserver", this.config.get(WebserverSettings.INTERNAL_IP) + ":" + this.port).build());
            this.enabled = false;
        }
    }

    private boolean startHttpsServer() throws BindException {
        String keyStorePath = this.config.get(WebserverSettings.CERTIFICATE_PATH);
        if ("proxy".equalsIgnoreCase(keyStorePath)) {
            return true;
        }
        try {
            if (!Paths.get(keyStorePath, new String[0]).isAbsolute()) {
                keyStorePath = this.files.getDataFolder() + File.separator + keyStorePath;
            }
        }
        catch (InvalidPathException e) {
            this.logger.error("WebServer: Could not find Keystore: " + e.getMessage());
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo(e.getMessage() + ", Fix this path to point to a valid keystore file: " + keyStorePath).related((Object)keyStorePath).build());
        }
        char[] storepass = this.config.get(WebserverSettings.CERTIFICATE_STOREPASS).toCharArray();
        char[] keypass = this.config.get(WebserverSettings.CERTIFICATE_KEYPASS).toCharArray();
        String alias = this.config.get(WebserverSettings.CERTIFICATE_ALIAS);
        boolean startSuccessful = false;
        String keyStoreKind = keyStorePath.endsWith(".p12") ? "PKCS12" : "JKS";
        try (FileInputStream fIn = new FileInputStream(keyStorePath);){
            KeyStore keystore = KeyStore.getInstance(keyStoreKind);
            keystore.load(fIn, storepass);
            Certificate cert = keystore.getCertificate(alias);
            if (cert == null) {
                throw new IllegalStateException("Alias: '" + alias + "' was not found in file " + keyStorePath + ".");
            }
            this.logger.info("Certificate: " + cert.getType());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keystore, keypass);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
            trustManagerFactory.init(keystore);
            this.server = HttpsServer.create(new InetSocketAddress(this.config.get(WebserverSettings.INTERNAL_IP), this.port), 10);
            final SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            ((HttpsServer)this.server).setHttpsConfigurator(new HttpsConfigurator(sslContext){

                @Override
                public void configure(HttpsParameters params) {
                    SSLEngine engine = sslContext.createSSLEngine();
                    params.setNeedClientAuth(false);
                    params.setCipherSuites(engine.getEnabledCipherSuites());
                    params.setProtocols(engine.getEnabledProtocols());
                    SSLParameters defaultSSLParameters = sslContext.getDefaultSSLParameters();
                    params.setSSLParameters(defaultSSLParameters);
                }
            });
            startSuccessful = true;
        }
        catch (IllegalStateException e) {
            this.logger.error(e.getMessage());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            this.logger.error(this.locale.getString(PluginLang.WEB_SERVER_FAIL_SSL_CONTEXT));
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)keyStoreKind).build());
        }
        catch (EOFException e) {
            this.logger.error(this.locale.getString(PluginLang.WEB_SERVER_FAIL_EMPTY_FILE));
        }
        catch (FileNotFoundException e) {
            this.logger.info(this.locale.getString(PluginLang.WEB_SERVER_NOTIFY_NO_CERT_FILE, new Serializable[]{keyStorePath}));
            this.logger.info(this.locale.getString(PluginLang.WEB_SERVER_NOTIFY_HTTP));
        }
        catch (BindException e) {
            throw e;
        }
        catch (IOException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().related((Object)(this.config.get(WebserverSettings.INTERNAL_IP) + ":" + this.port)).build());
        }
        catch (KeyStoreException | UnrecoverableKeyException | CertificateException e) {
            this.logger.error(this.locale.getString(PluginLang.WEB_SERVER_FAIL_STORE_LOAD));
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Make sure the Certificate settings are correct / You can try remaking the keystore without -passin or -passout parameters.").related((Object)keyStorePath).build());
        }
        return startSuccessful;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void disable() {
        if (this.server != null) {
            this.shutdown();
            this.logger.info(this.locale.getString(PluginLang.DISABLED_WEB_SERVER));
        }
        this.enabled = false;
    }

    private void shutdown() {
        this.server.stop(0);
        Executor executor = this.server.getExecutor();
        if (executor instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)executor;
            service.shutdown();
            try {
                if (!service.awaitTermination(5L, TimeUnit.SECONDS)) {
                    service.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                this.logger.error("WebServer ExecutorService shutdown thread interrupted on disable: " + e.getMessage());
                Thread.currentThread().interrupt();
            }
        }
    }

    public String getProtocol() {
        return this.usingHttps ? "https" : "http";
    }

    public boolean isUsingHTTPS() {
        return this.usingHttps;
    }

    public boolean isAuthRequired() {
        return this.isUsingHTTPS() && this.config.isFalse(WebserverSettings.DISABLED_AUTHENTICATION);
    }

    public int getPort() {
        return this.port;
    }
}

