/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.delivery.web.ResourceService;
import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.delivery.webserver.WebServer;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class WebServerSystem
implements SubSystem {
    private final Addresses addresses;
    private final WebServer webServer;

    @Inject
    public WebServerSystem(Addresses addresses, WebServer webServer) {
        this.addresses = addresses;
        this.webServer = webServer;
    }

    @Override
    public void enable() {
        this.webServer.enable();
        if (!this.webServer.isAuthRequired()) {
            ResourceService.getInstance().addStylesToResource("Plan", "error.html", ResourceService.Position.PRE_CONTENT, "./css/noauth.css");
            ResourceService.getInstance().addStylesToResource("Plan", "server.html", ResourceService.Position.PRE_CONTENT, "../css/noauth.css");
            ResourceService.getInstance().addStylesToResource("Plan", "player.html", ResourceService.Position.PRE_CONTENT, "../css/noauth.css");
            ResourceService.getInstance().addStylesToResource("Plan", "players.html", ResourceService.Position.PRE_CONTENT, "./css/noauth.css");
            ResourceService.getInstance().addStylesToResource("Plan", "network.html", ResourceService.Position.PRE_CONTENT, "./css/noauth.css");
        }
    }

    @Override
    public void disable() {
        this.webServer.disable();
        JSONCache.invalidateAll();
        JSONCache.cleanUp();
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    public Addresses getAddresses() {
        return this.addresses;
    }
}

