/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.auth;

import com.djrapitops.plan.delivery.domain.auth.User;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.com.github.benmanes.caffeine.cache.Cache;
import plan.com.github.benmanes.caffeine.cache.Caffeine;
import plan.org.apache.commons.codec.digest.DigestUtils;

public class ActiveCookieStore {
    private static final Cache<String, User> USERS_BY_COOKIE = Caffeine.newBuilder().expireAfterWrite(2L, TimeUnit.HOURS).build();

    public static Optional<User> checkCookie(String cookie) {
        return Optional.ofNullable(USERS_BY_COOKIE.getIfPresent(cookie));
    }

    public static String generateNewCookie(User user) {
        String cookie = DigestUtils.sha256Hex(user.getUsername() + UUID.randomUUID() + System.currentTimeMillis());
        USERS_BY_COOKIE.put(cookie, user);
        return cookie;
    }

    public static void removeCookie(String cookie) {
        USERS_BY_COOKIE.invalidate(cookie);
    }

    public static void removeCookie(User user) {
        USERS_BY_COOKIE.asMap().entrySet().stream().filter(entry -> ((User)entry.getValue()).getUsername().equals(user.getUsername())).findAny().map(Map.Entry::getKey).ifPresent(ActiveCookieStore::removeCookie);
    }
}

