/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.auth;

import com.djrapitops.plan.delivery.domain.auth.User;
import com.djrapitops.plan.delivery.webserver.auth.Authentication;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.exceptions.PassEncryptException;
import com.djrapitops.plan.exceptions.WebUserAuthException;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.WebUserQueries;
import com.djrapitops.plan.utilities.Base64Util;
import java.util.Arrays;
import plan.org.apache.commons.lang3.StringUtils;

public class BasicAuthentication
implements Authentication {
    private final String authenticationString;
    private final Database database;

    public BasicAuthentication(String authenticationString, Database database) {
        this.authenticationString = authenticationString;
        this.database = database;
    }

    @Override
    public User getUser() {
        String decoded = Base64Util.decode(this.authenticationString);
        Object[] userInfo = StringUtils.split(decoded, ':');
        if (userInfo.length != 2) {
            throw new WebUserAuthException(FailReason.USER_AND_PASS_NOT_SPECIFIED, Arrays.toString(userInfo));
        }
        String username = userInfo[0];
        Object passwordRaw = userInfo[1];
        Database.State dbState = this.database.getState();
        if (dbState != Database.State.OPEN) {
            throw new WebUserAuthException(FailReason.DATABASE_NOT_OPEN, "State was: " + dbState.name());
        }
        try {
            User user = this.database.query(WebUserQueries.fetchUser(username)).orElseThrow(() -> new WebUserAuthException(FailReason.USER_DOES_NOT_EXIST, username));
            boolean correctPass = user.doesPasswordMatch((String)passwordRaw);
            if (!correctPass) {
                throw new WebUserAuthException(FailReason.USER_PASS_MISMATCH, username);
            }
            return user;
        }
        catch (PassEncryptException | DBOpException e) {
            throw new WebUserAuthException(e);
        }
    }
}

