/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.auth;

import com.djrapitops.plan.delivery.domain.auth.User;
import com.djrapitops.plan.utilities.PassEncryptUtil;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.com.github.benmanes.caffeine.cache.Cache;
import plan.com.github.benmanes.caffeine.cache.Caffeine;
import plan.org.apache.commons.codec.digest.DigestUtils;

public class RegistrationBin {
    private static final Cache<String, AwaitingForRegistration> REGISTRATION_BIN = Caffeine.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();

    public static String addInfoForRegistration(String username, String password) {
        String hash = PassEncryptUtil.createHash(password);
        String code = DigestUtils.sha256Hex(username + password + System.currentTimeMillis()).substring(0, 12);
        REGISTRATION_BIN.put(code, new AwaitingForRegistration(username, hash));
        return code;
    }

    public static Optional<User> register(String code, UUID linkedToUUID) {
        AwaitingForRegistration found = REGISTRATION_BIN.getIfPresent(code);
        if (found == null) {
            return Optional.empty();
        }
        REGISTRATION_BIN.invalidate(code);
        return Optional.of(found.toUser(linkedToUUID));
    }

    public static boolean contains(String code) {
        return REGISTRATION_BIN.getIfPresent(code) != null;
    }

    private static class AwaitingForRegistration {
        private final String username;
        private final String passwordHash;

        public AwaitingForRegistration(String username, String passwordHash) {
            this.username = username;
            this.passwordHash = passwordHash;
        }

        public User toUser(UUID linkedToUUID) {
            return new User(this.username, null, linkedToUUID, this.passwordHash, 100, Collections.emptyList());
        }
    }
}

