/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.cache;

import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.storage.file.ResourceCache;
import com.djrapitops.plugin.task.AbsRunnable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import plan.com.github.benmanes.caffeine.cache.Cache;
import plan.com.github.benmanes.caffeine.cache.Caffeine;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;

public class JSONCache {
    private static final Cache<String, byte[]> cache = Caffeine.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();

    private JSONCache() {
    }

    public static Response getOrCache(String identifier, Supplier<Response> jsonResponseSupplier) {
        byte[] found = cache.getIfPresent(identifier);
        if (found == null) {
            Response response = jsonResponseSupplier.get();
            cache.put(identifier, response.getBytes());
            return response;
        }
        return Response.builder().setMimeType("application/json").setContent(found).build();
    }

    public static String getOrCacheString(DataID dataID, UUID serverUUID, Supplier<String> stringSupplier) {
        String identifier = dataID.of(serverUUID);
        byte[] found = cache.getIfPresent(identifier);
        if (found == null) {
            String result = stringSupplier.get();
            cache.put(identifier, result.getBytes(StandardCharsets.UTF_8));
            return result;
        }
        return new String(found, StandardCharsets.UTF_8);
    }

    public static <T> Response getOrCache(DataID dataID, Supplier<T> objectSupplier) {
        return JSONCache.getOrCache(dataID.name(), () -> Response.builder().setMimeType("application/json").setJSONContent(objectSupplier.get()).build());
    }

    public static <T> Response getOrCache(DataID dataID, UUID serverUUID, Supplier<T> objectSupplier) {
        return JSONCache.getOrCache(dataID.of(serverUUID), () -> Response.builder().setMimeType("application/json").setJSONContent(objectSupplier.get()).build());
    }

    public static void invalidate(String identifier) {
        cache.invalidate(identifier);
    }

    public static void invalidate(DataID dataID) {
        JSONCache.invalidate(dataID.name());
    }

    public static void invalidate(UUID serverUUID, DataID ... dataIDs) {
        for (DataID dataID : dataIDs) {
            JSONCache.invalidate(dataID.of(serverUUID));
        }
    }

    public static void invalidate(DataID dataID, UUID serverUUID) {
        JSONCache.invalidate(dataID.of(serverUUID));
    }

    public static void invalidateMatching(DataID ... dataIDs) {
        Set toInvalidate = Arrays.stream(dataIDs).map(Enum::name).collect(Collectors.toSet());
        for (String identifier : cache.asMap().keySet()) {
            for (String identifierToInvalidate : toInvalidate) {
                if (!StringUtils.startsWith(identifier, identifierToInvalidate)) continue;
                JSONCache.invalidate(identifier);
            }
        }
    }

    public static void invalidateMatching(DataID dataID) {
        String toInvalidate = dataID.name();
        for (String identifier : cache.asMap().keySet()) {
            if (!StringUtils.startsWith(identifier, toInvalidate)) continue;
            JSONCache.invalidate(identifier);
        }
    }

    public static void invalidateAll() {
        cache.invalidateAll();
    }

    public static void cleanUp() {
        cache.cleanUp();
    }

    public static List<String> getCachedIDs() {
        ArrayList<String> identifiers = new ArrayList<String>(cache.asMap().keySet());
        Collections.sort(identifiers);
        return identifiers;
    }

    @Singleton
    public static class CleanTask
    extends AbsRunnable {
        @Inject
        public CleanTask() {
        }

        @Override
        public void run() {
            JSONCache.cleanUp();
            ResourceCache.cleanUp();
        }
    }
}

