/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver;

import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.URIPath;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import com.djrapitops.plan.identification.UUIDUtility;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;

@Singleton
public class PlayerPageResolver
implements Resolver {
    private final ResponseFactory responseFactory;
    private final UUIDUtility uuidUtility;

    @Inject
    public PlayerPageResolver(ResponseFactory responseFactory, UUIDUtility uuidUtility) {
        this.responseFactory = responseFactory;
        this.uuidUtility = uuidUtility;
    }

    @Override
    public boolean canAccess(Request request) {
        URIPath path = request.getPath();
        WebUser user = request.getUser().orElse(new WebUser(""));
        boolean isOwnPage = path.getPart(1).map(user.getName()::equalsIgnoreCase).orElse(true);
        return user.hasPermission("page.player.other") || user.hasPermission("page.player.self") && isOwnPage;
    }

    @Override
    public Optional<Response> resolve(Request request) {
        URIPath path = request.getPath();
        if (StringUtils.containsAny((CharSequence)path.asString(), "/vendor/", "/js/", "/css/", "/img/")) {
            return Optional.empty();
        }
        return path.getPart(1).map(playerName -> this.getResponse(request.getPath(), (String)playerName));
    }

    private Response getResponse(URIPath path, String playerName) {
        UUID playerUUID = this.uuidUtility.getUUIDOf(playerName);
        if (playerUUID == null) {
            return this.responseFactory.uuidNotFound404();
        }
        boolean raw = path.getPart(2).map("raw"::equalsIgnoreCase).orElse(false);
        if (raw) {
            return this.responseFactory.rawPlayerPageResponse(playerUUID);
        }
        if (path.getPart(2).isPresent()) {
            return this.responseFactory.redirectResponse("../" + Html.encodeToURL(playerName));
        }
        return this.responseFactory.playerPageResponse(playerUUID);
    }
}

