/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver;

import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlayersPageResolver
implements Resolver {
    private final ResponseFactory responseFactory;

    @Inject
    public PlayersPageResolver(ResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }

    @Override
    public boolean canAccess(Request request) {
        return request.getUser().map(user -> user.hasPermission("page.players")).orElse(false);
    }

    @Override
    public Optional<Response> resolve(Request request) {
        if (request.getPath().getPart(1).isPresent()) {
            return Optional.of(this.responseFactory.redirectResponse("/players"));
        }
        return Optional.of(this.responseFactory.playersPageResponse());
    }
}

