/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver;

import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.web.resolver.NoAuthResolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import com.djrapitops.plan.delivery.webserver.WebServer;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.exceptions.WebUserAuthException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import java.util.Optional;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class RootPageResolver
implements NoAuthResolver {
    private final ResponseFactory responseFactory;
    private final Lazy<WebServer> webServer;
    private final ServerInfo serverInfo;

    @Inject
    public RootPageResolver(ResponseFactory responseFactory, Lazy<WebServer> webServer, ServerInfo serverInfo) {
        this.responseFactory = responseFactory;
        this.webServer = webServer;
        this.serverInfo = serverInfo;
    }

    @Override
    public Optional<Response> resolve(Request request) {
        return Optional.of(this.getResponse(request));
    }

    private Response getResponse(Request request) {
        Server server = this.serverInfo.getServer();
        if (!this.webServer.get().isAuthRequired()) {
            String redirectTo = server.isProxy() ? "network" : "server/" + Html.encodeToURL(server.getIdentifiableName());
            return this.responseFactory.redirectResponse(redirectTo);
        }
        WebUser user = request.getUser().orElseThrow(() -> new WebUserAuthException(FailReason.NO_USER_PRESENT));
        if (user.hasPermission("page.server")) {
            return this.responseFactory.redirectResponse(server.isProxy() ? "network" : "server/" + Html.encodeToURL(server.getIdentifiableName()));
        }
        if (user.hasPermission("page.players")) {
            return this.responseFactory.redirectResponse("players");
        }
        if (user.hasPermission("page.player.self")) {
            return this.responseFactory.redirectResponse("player/" + Html.encodeToURL(user.getName()));
        }
        return this.responseFactory.forbidden403(user.getName() + " has insufficient permissions to be redirected to any page. Needs one of: 'page.server', 'page.players' or 'page.player.self'");
    }
}

