/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver;

import com.djrapitops.plan.delivery.rendering.html.Html;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.URIPath;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ServerPageResolver
implements Resolver {
    private final ResponseFactory responseFactory;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;

    @Inject
    public ServerPageResolver(ResponseFactory responseFactory, DBSystem dbSystem, ServerInfo serverInfo) {
        this.responseFactory = responseFactory;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
    }

    @Override
    public boolean canAccess(Request request) {
        String firstPart = request.getPath().getPart(0).orElse("");
        WebUser permissions = request.getUser().orElse(new WebUser(""));
        boolean forServerPage = "server".equalsIgnoreCase(firstPart) && permissions.hasPermission("page.server");
        boolean forNetworkPage = "network".equalsIgnoreCase(firstPart) && permissions.hasPermission("page.network");
        return forServerPage || forNetworkPage;
    }

    @Override
    public Optional<Response> resolve(Request request) {
        return this.getServerUUID(request.getPath()).map(serverUUID -> this.getServerPage((UUID)serverUUID, request)).orElseGet(this::redirectToCurrentServer);
    }

    private Optional<Response> redirectToCurrentServer() {
        String directTo = this.serverInfo.getServer().isProxy() ? "/network" : "/server/" + Html.encodeToURL(this.serverInfo.getServer().getIdentifiableName());
        return Optional.of(this.responseFactory.redirectResponse(directTo));
    }

    private Optional<Response> getServerPage(UUID serverUUID, Request request) {
        boolean toNetworkPage;
        boolean bl = toNetworkPage = this.serverInfo.getServer().isProxy() && this.serverInfo.getServerUUID().equals(serverUUID);
        if (toNetworkPage) {
            if (request.getPath().getPart(0).map("network"::equals).orElse(false).booleanValue()) {
                return Optional.of(this.responseFactory.networkPageResponse());
            }
            return this.redirectToCurrentServer();
        }
        return Optional.of(this.responseFactory.serverPageResponse(serverUUID));
    }

    private Optional<UUID> getServerUUID(URIPath path) {
        if (this.serverInfo.getServer().isProxy() && path.getPart(0).map("network"::equals).orElse(false).booleanValue() && !path.getPart(1).isPresent()) {
            return Optional.of(this.serverInfo.getServerUUID());
        }
        return path.getPart(1).flatMap(serverName -> this.dbSystem.getDatabase().query(ServerQueries.fetchServerMatchingIdentifier(serverName)).map(Server::getUuid));
    }
}

