/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver;

import com.djrapitops.plan.delivery.web.resolver.NoAuthResolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.URIPath;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;

@Singleton
public class StaticResourceResolver
implements NoAuthResolver {
    private final ResponseFactory responseFactory;

    @Inject
    public StaticResourceResolver(ResponseFactory responseFactory) {
        this.responseFactory = responseFactory;
    }

    @Override
    public Optional<Response> resolve(Request request) {
        return Optional.ofNullable(this.getResponse(request));
    }

    private Response getResponse(Request request) {
        String resource = this.getPath(request).asString().substring(1);
        if (resource.endsWith(".css")) {
            return this.responseFactory.cssResponse(resource);
        }
        if (resource.endsWith(".js")) {
            return this.responseFactory.javaScriptResponse(resource);
        }
        if (resource.endsWith(".png")) {
            return this.responseFactory.imageResponse(resource);
        }
        if (StringUtils.endsWithAny(resource, ".woff", ".woff2", ".eot", ".ttf")) {
            return this.responseFactory.fontResponse(resource);
        }
        return null;
    }

    private URIPath getPath(Request request) {
        URIPath path = request.getPath();
        while (!path.getPart(0).map(part -> part.matches("(vendor|css|js|img)")).orElse(true).booleanValue()) {
            path = path.omitFirst();
        }
        return path;
    }
}

