/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.auth;

import com.djrapitops.plan.delivery.web.resolver.NoAuthResolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.ResponseFactory;
import com.djrapitops.plan.delivery.webserver.WebServer;
import java.util.Optional;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class LoginPageResolver
implements NoAuthResolver {
    private ResponseFactory responseFactory;
    private Lazy<WebServer> webServer;

    @Inject
    public LoginPageResolver(ResponseFactory responseFactory, Lazy<WebServer> webServer) {
        this.responseFactory = responseFactory;
        this.webServer = webServer;
    }

    @Override
    public Optional<Response> resolve(Request request) {
        Optional<WebUser> user = request.getUser();
        if (user.isPresent() || !this.webServer.get().isAuthRequired()) {
            Optional<String> from = request.getQuery().get("from");
            return Optional.of(this.responseFactory.redirectResponse(from.orElse("/")));
        }
        return Optional.of(this.responseFactory.loginPageResponse());
    }
}

