/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.auth;

import com.djrapitops.plan.delivery.web.resolver.NoAuthResolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.webserver.auth.ActiveCookieStore;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.exceptions.WebUserAuthException;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class LogoutResolver
implements NoAuthResolver {
    @Inject
    public LogoutResolver() {
    }

    @Override
    public Optional<Response> resolve(Request request) {
        String cookies = request.getHeader("Cookie").orElse("");
        String foundCookie = null;
        for (String cookie : cookies.split(";")) {
            if (cookie.isEmpty()) continue;
            String[] split = cookie.split("=");
            String name = split[0];
            String value = split[1];
            if (!"auth".equals(name)) continue;
            foundCookie = value;
            ActiveCookieStore.removeCookie(value);
        }
        if (foundCookie == null) {
            throw new WebUserAuthException(FailReason.NO_USER_PRESENT);
        }
        return Optional.of(this.getResponse(foundCookie));
    }

    public Response getResponse(String cookie) {
        return Response.builder().setStatus(200).setHeader("Set-Cookie", "auth=" + cookie + "; Max-Age=1").setMimeType("text/html").setContent("<p>Logging out..</p><script>const urlParams = new URLSearchParams(window.location.search);const cause = urlParams.get('cause');setTimeout(() => window.location.href = cause ? '../login?cause=' + cause : '../login', 1000);</script>").build();
    }
}

