/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.auth;

import com.djrapitops.plan.delivery.web.resolver.NoAuthResolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.exception.BadRequestException;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.URIQuery;
import com.djrapitops.plan.delivery.webserver.auth.RegistrationBin;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.WebUserQueries;
import com.djrapitops.plan.utilities.PassEncryptUtil;
import com.djrapitops.plan.utilities.java.Maps;
import java.util.Collections;
import java.util.Optional;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class RegisterResolver
implements NoAuthResolver {
    private DBSystem dbSystem;

    @Inject
    public RegisterResolver(DBSystem dbSystem) {
        this.dbSystem = dbSystem;
    }

    @Override
    public Optional<Response> resolve(Request request) {
        return Optional.of(this.getResponse(request));
    }

    public Response getResponse(Request request) {
        URIQuery query = request.getQuery();
        Optional<String> checkCode = query.get("code");
        if (checkCode.isPresent()) {
            return Response.builder().setStatus(200).setJSONContent(Collections.singletonMap("success", !RegistrationBin.contains(checkCode.get()))).build();
        }
        String username = query.get("user").orElseThrow(() -> new BadRequestException("'user' parameter not defined"));
        boolean alreadyExists = this.dbSystem.getDatabase().query(WebUserQueries.fetchUser(username)).isPresent();
        if (alreadyExists) {
            throw new BadRequestException("User '" + username + "' already exists!");
        }
        String password = query.get("password").orElseThrow(() -> new BadRequestException("'password' parameter not defined"));
        try {
            String code = RegistrationBin.addInfoForRegistration(username, password);
            return Response.builder().setStatus(200).setJSONContent(Maps.builder(String.class, Object.class).put("success", true).put("code", code).build()).build();
        }
        catch (PassEncryptUtil.CannotPerformOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

