/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.json;

import com.djrapitops.plan.delivery.rendering.json.graphs.GraphJSONCreator;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.exception.BadRequestException;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import com.djrapitops.plan.identification.Identifiers;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class GraphsJSONResolver
implements Resolver {
    private final Identifiers identifiers;
    private final GraphJSONCreator graphJSON;

    @Inject
    public GraphsJSONResolver(Identifiers identifiers, GraphJSONCreator graphJSON) {
        this.identifiers = identifiers;
        this.graphJSON = graphJSON;
    }

    @Override
    public boolean canAccess(Request request) {
        return request.getUser().orElse(new WebUser("")).hasPermission("page.server");
    }

    @Override
    public Optional<Response> resolve(Request request) {
        return Optional.of(this.getResponse(request));
    }

    private Response getResponse(Request request) {
        String type = request.getQuery().get("type").orElseThrow(() -> new BadRequestException("'type' parameter was not defined."));
        DataID dataID = this.getDataID(type);
        if (request.getQuery().get("server").isPresent()) {
            UUID serverUUID = this.identifiers.getServerUUID(request);
            return JSONCache.getOrCache(dataID, serverUUID, () -> this.generateGraphDataJSONOfType(dataID, serverUUID));
        }
        return JSONCache.getOrCache(dataID, () -> this.generateGraphDataJSONOfType(dataID));
    }

    private DataID getDataID(String type) {
        switch (type) {
            case "performance": {
                return DataID.GRAPH_PERFORMANCE;
            }
            case "playersOnline": {
                return DataID.GRAPH_ONLINE;
            }
            case "uniqueAndNew": {
                return DataID.GRAPH_UNIQUE_NEW;
            }
            case "hourlyUniqueAndNew": {
                return DataID.GRAPH_HOURLY_UNIQUE_NEW;
            }
            case "serverCalendar": {
                return DataID.GRAPH_CALENDAR;
            }
            case "worldPie": {
                return DataID.GRAPH_WORLD_PIE;
            }
            case "activity": {
                return DataID.GRAPH_ACTIVITY;
            }
            case "geolocation": {
                return DataID.GRAPH_WORLD_MAP;
            }
            case "aggregatedPing": {
                return DataID.GRAPH_PING;
            }
            case "punchCard": {
                return DataID.GRAPH_PUNCHCARD;
            }
            case "serverPie": {
                return DataID.GRAPH_SERVER_PIE;
            }
        }
        throw new BadRequestException("unknown 'type' parameter: " + type);
    }

    private Object generateGraphDataJSONOfType(DataID id, UUID serverUUID) {
        switch (id) {
            case GRAPH_PERFORMANCE: {
                return this.graphJSON.performanceGraphJSON(serverUUID);
            }
            case GRAPH_ONLINE: {
                return this.graphJSON.playersOnlineGraph(serverUUID);
            }
            case GRAPH_UNIQUE_NEW: {
                return this.graphJSON.uniqueAndNewGraphJSON(serverUUID);
            }
            case GRAPH_HOURLY_UNIQUE_NEW: {
                return this.graphJSON.hourlyUniqueAndNewGraphJSON(serverUUID);
            }
            case GRAPH_CALENDAR: {
                return this.graphJSON.serverCalendarJSON(serverUUID);
            }
            case GRAPH_WORLD_PIE: {
                return this.graphJSON.serverWorldPieJSONAsMap(serverUUID);
            }
            case GRAPH_ACTIVITY: {
                return this.graphJSON.activityGraphsJSONAsMap(serverUUID);
            }
            case GRAPH_WORLD_MAP: {
                return this.graphJSON.geolocationGraphsJSONAsMap(serverUUID);
            }
            case GRAPH_PING: {
                return this.graphJSON.pingGraphsJSON(serverUUID);
            }
            case GRAPH_PUNCHCARD: {
                return this.graphJSON.punchCardJSONAsMap(serverUUID);
            }
        }
        return Collections.singletonMap("error", "Undefined ID: " + id.name());
    }

    private Object generateGraphDataJSONOfType(DataID id) {
        switch (id) {
            case GRAPH_ACTIVITY: {
                return this.graphJSON.activityGraphsJSONAsMap();
            }
            case GRAPH_UNIQUE_NEW: {
                return this.graphJSON.uniqueAndNewGraphJSON();
            }
            case GRAPH_HOURLY_UNIQUE_NEW: {
                return this.graphJSON.hourlyUniqueAndNewGraphJSON();
            }
            case GRAPH_SERVER_PIE: {
                return this.graphJSON.serverPreferencePieJSONAsMap();
            }
            case GRAPH_WORLD_MAP: {
                return this.graphJSON.geolocationGraphsJSONAsMap();
            }
        }
        return Collections.singletonMap("error", "Undefined ID: " + id.name());
    }
}

