/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.json;

import com.djrapitops.plan.delivery.rendering.json.JSONFactory;
import com.djrapitops.plan.delivery.rendering.json.network.NetworkOverviewJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.network.NetworkPlayerBaseOverviewJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.network.NetworkSessionsOverviewJSONCreator;
import com.djrapitops.plan.delivery.rendering.json.network.NetworkTabJSONCreator;
import com.djrapitops.plan.delivery.web.resolver.CompositeResolver;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.resolver.json.NetworkTabJSONResolver;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NetworkJSONResolver {
    private final CompositeResolver resolver;

    @Inject
    public NetworkJSONResolver(JSONFactory jsonFactory, NetworkOverviewJSONCreator networkOverviewJSONCreator, NetworkPlayerBaseOverviewJSONCreator networkPlayerBaseOverviewJSONCreator, NetworkSessionsOverviewJSONCreator networkSessionsOverviewJSONCreator) {
        this.resolver = CompositeResolver.builder().add("overview", this.forJSON(DataID.SERVER_OVERVIEW, networkOverviewJSONCreator)).add("playerbaseOverview", this.forJSON(DataID.PLAYERBASE_OVERVIEW, networkPlayerBaseOverviewJSONCreator)).add("sessionsOverview", this.forJSON(DataID.SESSIONS_OVERVIEW, networkSessionsOverviewJSONCreator)).add("servers", this.forJSON(DataID.SERVERS, jsonFactory::serversAsJSONMaps)).add("pingTable", this.forJSON(DataID.PING_TABLE, jsonFactory::pingPerGeolocation)).build();
    }

    private <T> NetworkTabJSONResolver<T> forJSON(DataID dataID, NetworkTabJSONCreator<T> tabJSONCreator) {
        return new NetworkTabJSONResolver<T>(dataID, tabJSONCreator);
    }

    public CompositeResolver getResolver() {
        return this.resolver;
    }
}

