/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.delivery.webserver.resolver.json;

import com.djrapitops.plan.delivery.rendering.json.network.NetworkTabJSONCreator;
import com.djrapitops.plan.delivery.web.resolver.Resolver;
import com.djrapitops.plan.delivery.web.resolver.Response;
import com.djrapitops.plan.delivery.web.resolver.request.Request;
import com.djrapitops.plan.delivery.web.resolver.request.WebUser;
import com.djrapitops.plan.delivery.webserver.cache.DataID;
import com.djrapitops.plan.delivery.webserver.cache.JSONCache;
import java.util.Optional;
import java.util.function.Supplier;

public class NetworkTabJSONResolver<T>
implements Resolver {
    private final DataID dataID;
    private final Supplier<T> jsonCreator;

    public NetworkTabJSONResolver(DataID dataID, NetworkTabJSONCreator<T> jsonCreator) {
        this.dataID = dataID;
        this.jsonCreator = jsonCreator;
    }

    @Override
    public boolean canAccess(Request request) {
        return request.getUser().orElse(new WebUser("")).hasPermission("page.network");
    }

    @Override
    public Optional<Response> resolve(Request request) {
        return Optional.of(this.getResponse());
    }

    private Response getResponse() {
        return JSONCache.getOrCache(this.dataID, this.jsonCreator);
    }
}

